/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import android.os.Handler;
import android.os.Message;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.NavigationHelper;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLocationUpdate;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRouteProcessor;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorBackgroundThread;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.List;

class RouteProcessorHandlerCallback
implements Handler.Callback {
    private NavigationRouteProcessor routeProcessor;
    private RouteProcessorBackgroundThread.Listener listener;
    private Handler responseHandler;

    RouteProcessorHandlerCallback(NavigationRouteProcessor routeProcessor, Handler responseHandler, RouteProcessorBackgroundThread.Listener listener) {
        this.routeProcessor = routeProcessor;
        this.responseHandler = responseHandler;
        this.listener = listener;
    }

    public boolean handleMessage(Message msg) {
        NavigationLocationUpdate update = (NavigationLocationUpdate)msg.obj;
        this.handleRequest(update);
        return true;
    }

    private void handleRequest(NavigationLocationUpdate update) {
        MapboxNavigation mapboxNavigation = update.mapboxNavigation();
        Location rawLocation = update.location();
        RouteProgress routeProgress = this.routeProcessor.buildNewRouteProgress(mapboxNavigation, rawLocation);
        boolean userOffRoute = this.determineUserOffRoute(update, mapboxNavigation, routeProgress);
        List<Milestone> milestones = this.findTriggeredMilestones(mapboxNavigation, routeProgress);
        Location location = this.findSnappedLocation(mapboxNavigation, rawLocation, routeProgress, userOffRoute);
        boolean checkFasterRoute = this.findFasterRoute(update, mapboxNavigation, routeProgress, userOffRoute);
        RouteProgress finalRouteProgress = this.updateRouteProcessorWith(routeProgress);
        this.sendUpdateToListener(userOffRoute, milestones, location, checkFasterRoute, finalRouteProgress);
    }

    private List<Milestone> findTriggeredMilestones(MapboxNavigation mapboxNavigation, RouteProgress routeProgress) {
        RouteProgress previousRouteProgress = this.routeProcessor.getRouteProgress();
        return NavigationHelper.checkMilestones(previousRouteProgress, routeProgress, mapboxNavigation);
    }

    private Location findSnappedLocation(MapboxNavigation mapboxNavigation, Location rawLocation, RouteProgress routeProgress, boolean userOffRoute) {
        boolean snapToRouteEnabled = mapboxNavigation.options().snapToRoute();
        return NavigationHelper.buildSnappedLocation(mapboxNavigation, snapToRouteEnabled, rawLocation, routeProgress, userOffRoute);
    }

    private boolean determineUserOffRoute(NavigationLocationUpdate navigationLocationUpdate, MapboxNavigation mapboxNavigation, RouteProgress routeProgress) {
        boolean userOffRoute = NavigationHelper.isUserOffRoute(navigationLocationUpdate, routeProgress, this.routeProcessor);
        this.routeProcessor.checkIncreaseIndex(mapboxNavigation);
        return userOffRoute;
    }

    private boolean findFasterRoute(NavigationLocationUpdate navigationLocationUpdate, MapboxNavigation mapboxNavigation, RouteProgress routeProgress, boolean userOffRoute) {
        boolean fasterRouteEnabled = mapboxNavigation.options().enableFasterRouteDetection();
        return fasterRouteEnabled && !userOffRoute && NavigationHelper.shouldCheckFasterRoute(navigationLocationUpdate, routeProgress);
    }

    private RouteProgress updateRouteProcessorWith(RouteProgress routeProgress) {
        this.routeProcessor.setRouteProgress(routeProgress);
        return routeProgress;
    }

    private void sendUpdateToListener(final boolean userOffRoute, final List<Milestone> milestones, final Location location, final boolean checkFasterRoute, final RouteProgress finalRouteProgress) {
        this.responseHandler.post(new Runnable(){

            @Override
            public void run() {
                RouteProcessorHandlerCallback.this.listener.onNewRouteProgress(location, finalRouteProgress);
                RouteProcessorHandlerCallback.this.listener.onMilestoneTrigger(milestones, finalRouteProgress);
                RouteProcessorHandlerCallback.this.listener.onUserOffRoute(location, userOffRoute);
                RouteProcessorHandlerCallback.this.listener.onCheckFasterRoute(location, finalRouteProgress, checkFasterRoute);
            }
        });
    }
}

