/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.camera;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.navigation.camera.Camera;
import com.mapbox.services.android.navigation.v5.navigation.camera.RouteInformation;
import com.mapbox.turf.TurfMeasurement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleCamera
extends Camera {
    protected static final int DEFAULT_TILT = 50;
    protected static final double DEFAULT_ZOOM = 15.0;
    private List<Point> routeCoordinates = new ArrayList<Point>();
    private double initialBearing;
    private DirectionsRoute initialRoute;

    @Override
    public double bearing(RouteInformation routeInformation) {
        if (routeInformation.route() != null) {
            this.setupLineStringAndBearing(routeInformation.route());
            return this.initialBearing;
        }
        if (routeInformation.location() != null) {
            return routeInformation.location().getBearing();
        }
        return 0.0;
    }

    @Override
    public Point target(RouteInformation routeInformation) {
        Point targetPoint = null;
        if (routeInformation.route() != null) {
            this.setupLineStringAndBearing(routeInformation.route());
            double lng = this.routeCoordinates.get(0).longitude();
            double lat = this.routeCoordinates.get(0).latitude();
            return Point.fromLngLat((double)lng, (double)lat);
        }
        if (routeInformation.location() != null) {
            double lng = routeInformation.location().getLongitude();
            double lat = routeInformation.location().getLatitude();
            targetPoint = Point.fromLngLat((double)lng, (double)lat);
        }
        return targetPoint;
    }

    @Override
    public double tilt(RouteInformation routeInformation) {
        return 50.0;
    }

    @Override
    public double zoom(RouteInformation routeInformation) {
        return 15.0;
    }

    @Override
    public List<Point> overview(RouteInformation routeInformation) {
        boolean invalidCoordinates;
        boolean bl = invalidCoordinates = this.routeCoordinates == null || this.routeCoordinates.isEmpty();
        if (invalidCoordinates) {
            this.buildRouteCoordinatesFromRouteData(routeInformation);
        }
        return this.routeCoordinates;
    }

    private void buildRouteCoordinatesFromRouteData(RouteInformation routeInformation) {
        if (routeInformation.route() != null) {
            this.setupLineStringAndBearing(routeInformation.route());
        } else if (routeInformation.routeProgress() != null) {
            this.setupLineStringAndBearing(routeInformation.routeProgress().directionsRoute());
        }
    }

    private void setupLineStringAndBearing(DirectionsRoute route) {
        if (this.initialRoute != null && route.equals(this.initialRoute)) {
            return;
        }
        this.initialRoute = route;
        this.routeCoordinates = this.generateRouteCoordinates(route);
        this.initialBearing = TurfMeasurement.bearing((Point)Point.fromLngLat((double)this.routeCoordinates.get(0).longitude(), (double)this.routeCoordinates.get(0).latitude()), (Point)Point.fromLngLat((double)this.routeCoordinates.get(1).longitude(), (double)this.routeCoordinates.get(1).latitude()));
    }

    private List<Point> generateRouteCoordinates(DirectionsRoute route) {
        if (route == null) {
            return Collections.emptyList();
        }
        LineString lineString = LineString.fromPolyline((String)route.geometry(), (int)6);
        return lineString.coordinates();
    }
}

