/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.offroute;

import android.location.Location;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.offroute.OffRoute;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteCallback;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.MeasurementUtils;
import com.mapbox.services.android.navigation.v5.utils.RingBuffer;
import com.mapbox.services.android.navigation.v5.utils.ToleranceUtils;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.TurfMisc;
import java.util.List;

public class OffRouteDetector
extends OffRoute {
    private Point lastReroutePoint;
    private OffRouteCallback callback;
    private RingBuffer<Integer> distancesAwayFromManeuver = new RingBuffer(3);
    private static final int TWO_POINTS = 2;

    @Override
    public boolean isUserOffRoute(Location location, RouteProgress routeProgress, MapboxNavigationOptions options) {
        if (this.checkDistanceRemaining(routeProgress)) {
            return true;
        }
        if (!this.validOffRoute(location, options)) {
            return false;
        }
        Point currentPoint = Point.fromLngLat((double)location.getLongitude(), (double)location.getLatitude());
        boolean isOffRoute = this.checkOffRouteRadius(location, routeProgress, options, currentPoint);
        if (!isOffRoute) {
            return this.isMovingAwayFromManeuver(location, routeProgress, this.distancesAwayFromManeuver, currentPoint);
        }
        LegStep upComingStep = routeProgress.currentLegProgress().upComingStep();
        if (OffRouteDetector.closeToUpcomingStep(options, this.callback, currentPoint, upComingStep)) {
            return false;
        }
        this.updateLastReroutePoint(location);
        return true;
    }

    public void setOffRouteCallback(OffRouteCallback callback) {
        this.callback = callback;
    }

    public void clearDistancesAwayFromManeuver() {
        this.distancesAwayFromManeuver.clear();
    }

    private boolean checkDistanceRemaining(RouteProgress routeProgress) {
        return routeProgress.distanceRemaining() == 0.0;
    }

    private boolean validOffRoute(Location location, MapboxNavigationOptions options) {
        Point currentPoint = Point.fromLngLat((double)location.getLongitude(), (double)location.getLatitude());
        double distanceFromLastReroute = 0.0;
        if (this.lastReroutePoint != null) {
            distanceFromLastReroute = TurfMeasurement.distance((Point)this.lastReroutePoint, (Point)currentPoint, (String)"meters");
        } else {
            this.updateLastReroutePoint(location);
        }
        return distanceFromLastReroute > options.minimumDistanceBeforeRerouting();
    }

    private boolean checkOffRouteRadius(Location location, RouteProgress routeProgress, MapboxNavigationOptions options, Point currentPoint) {
        double offRouteRadius;
        LegStep currentStep = routeProgress.currentLegProgress().currentStep();
        double distanceFromCurrentStep = MeasurementUtils.userTrueDistanceFromStep(currentPoint, currentStep);
        return distanceFromCurrentStep > (offRouteRadius = this.createOffRouteRadius(location, routeProgress, options, currentPoint));
    }

    private double createOffRouteRadius(Location location, RouteProgress routeProgress, MapboxNavigationOptions options, Point currentPoint) {
        double dynamicTolerance = ToleranceUtils.dynamicRerouteDistanceTolerance(currentPoint, routeProgress, options);
        double accuracyTolerance = (double)location.getAccuracy() * options.deadReckoningTimeInterval();
        return Math.max(dynamicTolerance, accuracyTolerance);
    }

    private boolean isMovingAwayFromManeuver(Location location, RouteProgress routeProgress, RingBuffer<Integer> distancesAwayFromManeuver, Point currentPoint) {
        List<Point> stepPoints = routeProgress.currentStepPoints();
        if (OffRouteDetector.movingAwayFromManeuver(routeProgress, distancesAwayFromManeuver, stepPoints, currentPoint)) {
            this.updateLastReroutePoint(location);
            return true;
        }
        return false;
    }

    private static boolean closeToUpcomingStep(MapboxNavigationOptions options, OffRouteCallback callback, Point currentPoint, LegStep upComingStep) {
        if (callback == null) {
            return false;
        }
        if (upComingStep != null) {
            double maneuverZoneRadius;
            boolean isCloseToUpcomingStep;
            double distanceFromUpcomingStep = MeasurementUtils.userTrueDistanceFromStep(currentPoint, upComingStep);
            boolean bl = isCloseToUpcomingStep = distanceFromUpcomingStep < (maneuverZoneRadius = options.maneuverZoneRadius());
            if (isCloseToUpcomingStep) {
                callback.onShouldIncreaseIndex();
                return true;
            }
        }
        return false;
    }

    private static boolean movingAwayFromManeuver(RouteProgress routeProgress, RingBuffer<Integer> distancesAwayFromManeuver, List<Point> stepPoints, Point currentPoint) {
        boolean exceedsManeuverDistancesThreshold;
        boolean invalidStepPointSize;
        boolean invalidUpcomingStep = routeProgress.currentLegProgress().upComingStep() == null;
        boolean bl = invalidStepPointSize = stepPoints.size() < 2;
        if (invalidUpcomingStep || invalidStepPointSize) {
            return false;
        }
        LineString stepLineString = LineString.fromLngLats(stepPoints);
        Point maneuverPoint = stepPoints.get(stepPoints.size() - 1);
        Point userPointOnStep = (Point)TurfMisc.nearestPointOnLine((Point)currentPoint, stepPoints).geometry();
        if (userPointOnStep == null || maneuverPoint.equals((Object)userPointOnStep)) {
            return false;
        }
        LineString remainingStepLineString = TurfMisc.lineSlice((Point)userPointOnStep, (Point)maneuverPoint, (LineString)stepLineString);
        double userDistanceToManeuver = TurfMeasurement.length((LineString)remainingStepLineString, (String)"meters");
        boolean hasDistances = !distancesAwayFromManeuver.isEmpty();
        boolean validOffRouteDistanceTraveled = hasDistances && (double)((Integer)distancesAwayFromManeuver.peekLast() - (Integer)distancesAwayFromManeuver.peekFirst()) < 50.0;
        boolean bl2 = exceedsManeuverDistancesThreshold = validOffRouteDistanceTraveled && distancesAwayFromManeuver.size() >= 3;
        if (exceedsManeuverDistancesThreshold) {
            return true;
        }
        if (distancesAwayFromManeuver.isEmpty()) {
            distancesAwayFromManeuver.push((int)userDistanceToManeuver);
        } else if (userDistanceToManeuver > (double)((Integer)distancesAwayFromManeuver.peek()).intValue()) {
            distancesAwayFromManeuver.push((int)userDistanceToManeuver);
        } else {
            distancesAwayFromManeuver.clear();
        }
        return false;
    }

    private void updateLastReroutePoint(Location location) {
        this.lastReroutePoint = Point.fromLngLat((double)location.getLongitude(), (double)location.getLatitude());
    }
}

