/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.route;

import android.location.Location;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.services.android.navigation.v5.route.FasterRoute;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteStepProgress;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class FasterRouteDetector
extends FasterRoute {
    private static final int VALID_ROUTE_DURATION_REMAINING = 600;
    private Location lastCheckedLocation;

    @Override
    public boolean shouldCheckFasterRoute(Location location, RouteProgress routeProgress) {
        if (location == null || routeProgress == null) {
            return false;
        }
        if (this.lastCheckedLocation == null) {
            this.lastCheckedLocation = location;
        }
        if (this.secondsSinceLastCheck(location) >= 120L) {
            this.lastCheckedLocation = location;
            if (this.validRouteDurationRemaining(routeProgress) && this.validStepDurationRemaining(routeProgress)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFasterRoute(DirectionsResponse response, RouteProgress routeProgress) {
        if (this.validRouteResponse(response)) {
            RouteLeg routeLeg;
            double currentDurationRemaining = routeProgress.durationRemaining();
            DirectionsRoute newRoute = (DirectionsRoute)response.routes().get(0);
            if (this.hasLegs(newRoute) && this.hasAtLeastTwoSteps(routeLeg = (RouteLeg)newRoute.legs().get(0))) {
                LegStep firstStep = (LegStep)routeLeg.steps().get(0);
                LegStep secondStep = (LegStep)routeLeg.steps().get(1);
                if (!this.validFirstStep(firstStep) || !this.validSecondStep(secondStep, routeProgress)) {
                    return false;
                }
            }
            if (newRoute.duration() <= 0.9 * currentDurationRemaining) {
                return true;
            }
        }
        return false;
    }

    private boolean hasLegs(DirectionsRoute newRoute) {
        return newRoute.legs() != null && !newRoute.legs().isEmpty();
    }

    private boolean hasAtLeastTwoSteps(RouteLeg routeLeg) {
        return routeLeg.steps() != null && routeLeg.steps().size() > 2;
    }

    private boolean validSecondStep(LegStep secondStep, RouteProgress routeProgress) {
        return routeProgress.currentLegProgress().upComingStep() != null && routeProgress.currentLegProgress().upComingStep().equals(secondStep);
    }

    private boolean validFirstStep(LegStep firstStep) {
        return firstStep.duration() > 70.0;
    }

    private boolean validRouteResponse(DirectionsResponse response) {
        return response != null && !response.routes().isEmpty();
    }

    private boolean validRouteDurationRemaining(RouteProgress routeProgress) {
        int routeDurationRemaining = (int)routeProgress.durationRemaining();
        return routeDurationRemaining > 600;
    }

    private boolean validStepDurationRemaining(RouteProgress routeProgress) {
        RouteStepProgress currentStepProgress = routeProgress.currentLegProgress().currentStepProgress();
        int currentStepDurationRemaining = (int)currentStepProgress.durationRemaining();
        return currentStepDurationRemaining > 70;
    }

    private long secondsSinceLastCheck(Location location) {
        return this.dateDiff(new Date(this.lastCheckedLocation.getTime()), new Date(location.getTime()), TimeUnit.SECONDS);
    }

    private long dateDiff(Date firstDate, Date secondDate, TimeUnit timeUnit) {
        long diffInMillis = secondDate.getTime() - firstDate.getTime();
        return timeUnit.convert(diffInMillis, TimeUnit.MILLISECONDS);
    }
}

