/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.route;

import android.content.Context;
import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRoute;
import com.mapbox.services.android.navigation.v5.route.RouteListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import timber.log.Timber;

public class RouteFetcher {
    private static final double BEARING_TOLERANCE = 90.0;
    private static final String SEMICOLON = ";";
    private static final int ORIGIN_APPROACH_THRESHOLD = 1;
    private static final int ORIGIN_APPROACH = 0;
    private static final int FIRST_POSITION = 0;
    private static final int SECOND_POSITION = 1;
    private final List<RouteListener> routeListeners = new CopyOnWriteArrayList<RouteListener>();
    private final WeakReference<Context> contextWeakReference;
    private RouteProgress routeProgress;
    private RouteUtils routeUtils;
    private NavigationRoute navigationRoute;
    private Callback<DirectionsResponse> directionsResponseCallback = new Callback<DirectionsResponse>(){

        public void onResponse(@NonNull Call<DirectionsResponse> call, @NonNull Response<DirectionsResponse> response) {
            if (!response.isSuccessful()) {
                return;
            }
            RouteFetcher.this.updateListeners((DirectionsResponse)response.body(), RouteFetcher.this.routeProgress);
        }

        public void onFailure(@NonNull Call<DirectionsResponse> call, @NonNull Throwable throwable) {
            RouteFetcher.this.updateListenersWithError(throwable);
        }
    };

    public RouteFetcher(Context context) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.routeUtils = new RouteUtils();
    }

    public void addRouteListener(RouteListener listener) {
        if (!this.routeListeners.contains(listener)) {
            this.routeListeners.add(listener);
        }
    }

    public void clearListeners() {
        this.routeListeners.clear();
    }

    public void findRouteFromRouteProgress(Location location, RouteProgress routeProgress) {
        this.routeProgress = routeProgress;
        NavigationRoute.Builder builder = this.buildRequest(location, routeProgress);
        this.findRouteWith(builder);
    }

    @Nullable
    public NavigationRoute.Builder buildRequest(Location location, RouteProgress progress) {
        Context context = (Context)this.contextWeakReference.get();
        if (this.invalid(context, location, this.routeProgress)) {
            return null;
        }
        Point origin = Point.fromLngLat((double)location.getLongitude(), (double)location.getLatitude());
        Double bearing = location.hasBearing() ? Double.valueOf(Float.valueOf(location.getBearing()).doubleValue()) : null;
        RouteOptions options = progress.directionsRoute().routeOptions();
        NavigationRoute.Builder builder = NavigationRoute.builder(context).origin(origin, bearing, 90.0).routeOptions(options);
        List<Point> remainingWaypoints = this.routeUtils.calculateRemainingWaypoints(progress);
        if (remainingWaypoints == null) {
            Timber.e((String)"An error occurred fetching a new route", (Object[])new Object[0]);
            return null;
        }
        this.addDestination(remainingWaypoints, builder);
        this.addWaypoints(remainingWaypoints, builder);
        this.addWaypointNames(progress, builder);
        this.addApproaches(progress, builder);
        return builder;
    }

    private void addDestination(List<Point> remainingWaypoints, NavigationRoute.Builder builder) {
        if (!remainingWaypoints.isEmpty()) {
            builder.destination(this.retrieveDestinationWaypoint(remainingWaypoints));
        }
    }

    private Point retrieveDestinationWaypoint(List<Point> remainingWaypoints) {
        int lastWaypoint = remainingWaypoints.size() - 1;
        return remainingWaypoints.remove(lastWaypoint);
    }

    private void addWaypoints(List<Point> remainingCoordinates, NavigationRoute.Builder builder) {
        if (!remainingCoordinates.isEmpty()) {
            for (Point coordinate : remainingCoordinates) {
                builder.addWaypoint(coordinate);
            }
        }
    }

    private void addWaypointNames(RouteProgress progress, NavigationRoute.Builder builder) {
        String[] remainingWaypointNames = this.routeUtils.calculateRemainingWaypointNames(progress);
        if (remainingWaypointNames != null) {
            builder.addWaypointNames(remainingWaypointNames);
        }
    }

    private void addApproaches(RouteProgress progress, NavigationRoute.Builder builder) {
        String[] remainingApproaches = this.calculateRemainingApproaches(progress);
        if (remainingApproaches != null) {
            builder.addApproaches(remainingApproaches);
        }
    }

    private String[] calculateRemainingApproaches(RouteProgress routeProgress) {
        RouteOptions routeOptions = routeProgress.directionsRoute().routeOptions();
        if (routeOptions == null || TextUtils.isEmpty((CharSequence)routeOptions.approaches())) {
            return null;
        }
        String allApproaches = routeOptions.approaches();
        String[] splitApproaches = allApproaches.split(SEMICOLON);
        int coordinatesSize = routeProgress.directionsRoute().routeOptions().coordinates().size();
        String[] remainingApproaches = Arrays.copyOfRange(splitApproaches, coordinatesSize - routeProgress.remainingWaypoints(), coordinatesSize);
        String[] approaches = new String[remainingApproaches.length + 1];
        approaches[0] = splitApproaches[0];
        System.arraycopy(remainingApproaches, 0, approaches, 1, remainingApproaches.length);
        return approaches;
    }

    public void cancelRouteCall() {
        if (this.navigationRoute != null) {
            this.navigationRoute.cancelCall();
        }
    }

    public void findRouteWith(NavigationRoute.Builder builder) {
        if (builder != null) {
            this.navigationRoute = builder.build();
            this.navigationRoute.getRoute(this.directionsResponseCallback);
        }
    }

    private boolean isInvalidProgress(Location location, RouteProgress routeProgress) {
        return location == null || routeProgress == null;
    }

    private boolean invalid(Context context, Location location, RouteProgress routeProgress) {
        return context == null || location == null || routeProgress == null;
    }

    private void updateListeners(DirectionsResponse response, RouteProgress routeProgress) {
        for (RouteListener listener : this.routeListeners) {
            listener.onResponseReceived(response, routeProgress);
        }
    }

    private void updateListenersWithError(Throwable throwable) {
        for (RouteListener listener : this.routeListeners) {
            listener.onErrorReceived(throwable);
        }
    }
}

