/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.routeprogress;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.StepManeuver;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteLegProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;

public class MetricsRouteProgress {
    private int directionsRouteDistance;
    private int directionsRouteDuration;
    private String directionsRouteProfile;
    private Point directionsRouteDestination;
    private int distanceRemaining;
    private int durationRemaining;
    private int distanceTraveled;
    private int currentStepDistance;
    private int currentStepDuration;
    private int currentStepDistanceRemaining;
    private int currentStepDurationRemaining;
    private String currentStepName;
    private String upcomingStepInstruction;
    private String upcomingStepModifier;
    private String upcomingStepType;
    private String upcomingStepName;
    private String previousStepInstruction;
    private String previousStepModifier;
    private String previousStepType;
    private String previousStepName;

    public MetricsRouteProgress(@Nullable RouteProgress routeProgress) {
        if (routeProgress != null) {
            this.obtainRouteData(routeProgress.directionsRoute());
            this.obtainLegData(routeProgress.currentLegProgress());
            this.obtainStepData(routeProgress);
            this.distanceRemaining = (int)routeProgress.distanceRemaining();
            this.durationRemaining = (int)routeProgress.durationRemaining();
            this.distanceTraveled = (int)routeProgress.distanceTraveled();
        } else {
            this.initDefaultValues();
        }
    }

    private void initDefaultValues() {
        this.directionsRouteProfile = "";
        this.directionsRouteDestination = Point.fromLngLat((double)0.0, (double)0.0);
        this.currentStepName = "";
        this.upcomingStepInstruction = "";
        this.upcomingStepModifier = "";
        this.upcomingStepType = "";
        this.upcomingStepName = "";
        this.previousStepInstruction = "";
        this.previousStepModifier = "";
        this.previousStepType = "";
        this.previousStepName = "";
    }

    private void obtainRouteData(DirectionsRoute route) {
        this.directionsRouteDistance = route.distance() != null ? route.distance().intValue() : 0;
        this.directionsRouteDuration = route.duration() != null ? route.duration().intValue() : 0;
        this.directionsRouteProfile = this.hasRouteProfile(route) ? route.routeOptions().profile() : "";
        this.directionsRouteDestination = this.retrieveRouteDestination(route);
    }

    private void obtainLegData(RouteLegProgress legProgress) {
        this.currentStepDistance = (int)legProgress.currentStep().distance();
        this.currentStepDuration = (int)legProgress.currentStep().duration();
        this.currentStepDistanceRemaining = (int)legProgress.currentStepProgress().distanceRemaining();
        this.currentStepDurationRemaining = (int)legProgress.currentStepProgress().durationRemaining();
        this.currentStepName = this.hasStepName(legProgress) ? legProgress.currentStep().name() : "";
    }

    private void obtainStepData(RouteProgress routeProgress) {
        StepManeuver currentManeuver;
        RouteLegProgress legProgress = routeProgress.currentLegProgress();
        if (legProgress.upComingStep() != null) {
            this.upcomingStepName = legProgress.upComingStep().name();
            StepManeuver upcomingManeuver = legProgress.upComingStep().maneuver();
            if (upcomingManeuver != null) {
                this.upcomingStepInstruction = upcomingManeuver.instruction();
                this.upcomingStepType = upcomingManeuver.type();
                this.upcomingStepModifier = upcomingManeuver.modifier();
            }
        }
        if ((currentManeuver = legProgress.currentStep().maneuver()) != null) {
            this.previousStepInstruction = currentManeuver.instruction();
            this.previousStepType = currentManeuver.type();
            this.previousStepModifier = currentManeuver.modifier();
        }
        this.previousStepName = this.currentStepName;
    }

    private boolean hasRouteProfile(DirectionsRoute route) {
        return route.routeOptions() != null && !TextUtils.isEmpty((CharSequence)route.routeOptions().profile());
    }

    private Point retrieveRouteDestination(DirectionsRoute route) {
        RouteLeg lastLeg = (RouteLeg)route.legs().get(route.legs().size() - 1);
        LegStep lastStep = (LegStep)lastLeg.steps().get(lastLeg.steps().size() - 1);
        StepManeuver finalManuever = lastStep.maneuver();
        if (finalManuever.location() != null) {
            return finalManuever.location();
        }
        return Point.fromLngLat((double)0.0, (double)0.0);
    }

    private boolean hasStepName(RouteLegProgress legProgress) {
        return legProgress.currentStep().name() != null && !TextUtils.isEmpty((CharSequence)legProgress.currentStep().name());
    }

    public int getDirectionsRouteDistance() {
        return this.directionsRouteDistance;
    }

    public int getDirectionsRouteDuration() {
        return this.directionsRouteDuration;
    }

    public String getDirectionsRouteProfile() {
        return this.directionsRouteProfile;
    }

    public Point getDirectionsRouteDestination() {
        return this.directionsRouteDestination;
    }

    public int getDistanceRemaining() {
        return this.distanceRemaining;
    }

    public int getDurationRemaining() {
        return this.durationRemaining;
    }

    public int getDistanceTraveled() {
        return this.distanceTraveled;
    }

    public int getCurrentStepDistance() {
        return this.currentStepDistance;
    }

    public int getCurrentStepDuration() {
        return this.currentStepDuration;
    }

    public int getCurrentStepDistanceRemaining() {
        return this.currentStepDistanceRemaining;
    }

    public int getCurrentStepDurationRemaining() {
        return this.currentStepDurationRemaining;
    }

    public String getUpcomingStepInstruction() {
        return this.upcomingStepInstruction;
    }

    public String getUpcomingStepModifier() {
        return this.upcomingStepModifier;
    }

    public String getUpcomingStepType() {
        return this.upcomingStepType;
    }

    public String getUpcomingStepName() {
        return this.upcomingStepName;
    }

    public String getPreviousStepInstruction() {
        return this.previousStepInstruction;
    }

    public String getPreviousStepModifier() {
        return this.previousStepModifier;
    }

    public String getPreviousStepType() {
        return this.previousStepType;
    }

    public String getPreviousStepName() {
        return this.previousStepName;
    }
}

