/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.snap;

import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteLegProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteStepProgress;
import com.mapbox.services.android.navigation.v5.snap.Snap;
import com.mapbox.services.android.navigation.v5.utils.MathUtils;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.TurfMisc;
import java.util.List;

public class SnapToRoute
extends Snap {
    @Override
    public Location getSnappedLocation(Location location, RouteProgress routeProgress) {
        Location snappedLocation = SnapToRoute.snapLocationLatLng(location, routeProgress.currentStepPoints());
        snappedLocation.setBearing(SnapToRoute.snapLocationBearing(routeProgress));
        return snappedLocation;
    }

    private static Location snapLocationLatLng(Location location, List<Point> stepCoordinates) {
        Location snappedLocation = new Location(location);
        Point locationToPoint = Point.fromLngLat((double)location.getLongitude(), (double)location.getLatitude());
        if (stepCoordinates.size() > 1) {
            Feature feature = TurfMisc.nearestPointOnLine((Point)locationToPoint, stepCoordinates);
            Point point = (Point)feature.geometry();
            snappedLocation.setLongitude(point.longitude());
            snappedLocation.setLatitude(point.latitude());
        }
        return snappedLocation;
    }

    private static float snapLocationBearing(RouteProgress routeProgress) {
        RouteLegProgress legProgress = routeProgress.currentLegProgress();
        RouteStepProgress stepProgress = legProgress.currentStepProgress();
        double distanceTraveled = stepProgress.distanceTraveled();
        double distanceRemaining = stepProgress.distanceRemaining();
        boolean distanceRemainingZero = distanceRemaining == 0.0;
        double distanceAhead = distanceRemainingZero ? 1.0 : distanceTraveled + 1.0;
        LineString upcomingLineString = SnapToRoute.createUpcomingLineString(legProgress, distanceRemainingZero);
        LineString currentLineString = SnapToRoute.createCurrentLineString(legProgress);
        Point futurePoint = SnapToRoute.createFuturePoint(distanceAhead, upcomingLineString, currentLineString);
        Point currentPoint = null;
        if (currentLineString.coordinates().size() > 0) {
            currentPoint = TurfMeasurement.along((LineString)currentLineString, (double)distanceTraveled, (String)"meters");
        }
        if (currentPoint != null && futurePoint != null) {
            double azimuth = TurfMeasurement.bearing((Point)currentPoint, (Point)futurePoint);
            return (float)MathUtils.wrap(azimuth, 0.0, 360.0);
        }
        return 0.0f;
    }

    @NonNull
    private static LineString createCurrentLineString(RouteLegProgress legProgress) {
        String currentGeometry = legProgress.currentStep().geometry();
        return LineString.fromPolyline((String)currentGeometry, (int)6);
    }

    @Nullable
    private static LineString createUpcomingLineString(RouteLegProgress legProgress, boolean distanceRemainingZero) {
        LineString upcomingLineString = null;
        if (distanceRemainingZero && legProgress.upComingStep() != null) {
            String upcomingGeometry = legProgress.upComingStep().geometry();
            upcomingLineString = LineString.fromPolyline((String)upcomingGeometry, (int)6);
        }
        return upcomingLineString;
    }

    @Nullable
    private static Point createFuturePoint(double distanceAhead, LineString upcomingLineString, LineString currentLineString) {
        Point futurePoint;
        if (upcomingLineString != null && upcomingLineString.coordinates().size() > 0) {
            futurePoint = TurfMeasurement.along((LineString)upcomingLineString, (double)distanceAhead, (String)"meters");
        } else if (currentLineString != null && currentLineString.coordinates().size() > 0) {
            futurePoint = TurfMeasurement.along((LineString)currentLineString, (double)distanceAhead, (String)"meters");
        } else {
            return null;
        }
        return futurePoint;
    }
}

