/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import java.util.Locale;

public class LocaleUtils {
    public String getUnitTypeForLocale(@NonNull Locale locale) {
        switch (locale.getCountry()) {
            case "US": 
            case "LR": 
            case "MM": {
                return "imperial";
            }
        }
        return "metric";
    }

    public String inferDeviceLanguage(Context context) {
        return this.inferDeviceLocale(context).getLanguage();
    }

    public Locale inferDeviceLocale(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return context.getResources().getConfiguration().getLocales().get(0);
        }
        return context.getResources().getConfiguration().locale;
    }

    public String getNonEmptyLanguage(Context context, String language) {
        if (language == null) {
            return this.inferDeviceLanguage(context);
        }
        return language;
    }

    public String getUnitTypeForDeviceLocale(Context context) {
        return this.getUnitTypeForLocale(this.inferDeviceLocale(context));
    }

    public String retrieveNonNullUnitType(Context context, String unitType) {
        if (unitType == null) {
            return this.getUnitTypeForDeviceLocale(context);
        }
        return unitType;
    }
}

