/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;

public final class MapUtils {
    private MapUtils() {
    }

    public static void updateMapSourceFromFeatureCollection(@NonNull MapboxMap mapboxMap, @Nullable FeatureCollection collection, @NonNull String sourceId) {
        if (collection == null) {
            collection = FeatureCollection.fromFeatures((Feature[])new Feature[0]);
        }
        if (mapboxMap.getStyle() != null) {
            GeoJsonSource source = (GeoJsonSource)mapboxMap.getStyle().getSourceAs(sourceId);
            if (source == null) {
                GeoJsonOptions routeGeoJsonOptions = new GeoJsonOptions().withMaxZoom(16);
                GeoJsonSource routeSource = new GeoJsonSource(sourceId, collection, routeGeoJsonOptions);
                mapboxMap.getStyle().addSource((Source)routeSource);
            } else {
                source.setGeoJson(collection);
            }
        }
    }

    public static void addLayerToMap(@NonNull MapboxMap mapboxMap, @NonNull Layer layer, @Nullable String idBelowLayer) {
        try {
            if (mapboxMap.getStyle().getLayer(layer.getId()) != null) {
                return;
            }
            if (idBelowLayer == null) {
                mapboxMap.getStyle().addLayer(layer);
            } else {
                mapboxMap.getStyle().addLayerBelow(layer, idBelowLayer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

