/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.BannerText;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.api.directions.v5.models.VoiceInstructions;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.milestone.BannerInstructionMilestone;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RouteUtils {
    private static final String FORCED_LOCATION = "Forced Location";
    private static final int FIRST_COORDINATE = 0;
    private static final int FIRST_INSTRUCTION = 0;
    private static final int ORIGIN_WAYPOINT_NAME_THRESHOLD = 1;
    private static final int ORIGIN_WAYPOINT_NAME = 0;
    private static final int FIRST_POSITION = 0;
    private static final int SECOND_POSITION = 1;
    private static final String SEMICOLON = ";";
    private static final Set<String> VALID_PROFILES = new HashSet<String>(Arrays.asList("driving-traffic", "driving", "cycling", "walking"));

    public boolean isNewRoute(@Nullable RouteProgress previousRouteProgress, @NonNull RouteProgress routeProgress) {
        return this.isNewRoute(previousRouteProgress, routeProgress.directionsRoute());
    }

    public boolean isNewRoute(@Nullable RouteProgress previousRouteProgress, @NonNull DirectionsRoute directionsRoute) {
        return previousRouteProgress == null || !previousRouteProgress.directionsRoute().geometry().equals(directionsRoute.geometry());
    }

    public boolean isArrivalEvent(@NonNull RouteProgress routeProgress, @NonNull Milestone milestone) {
        boolean isValidArrivalManeuverType;
        if (!(milestone instanceof BannerInstructionMilestone)) {
            return false;
        }
        boolean bl = isValidArrivalManeuverType = this.upcomingStepIsArrivalManeuverType(routeProgress) || this.currentStepIsArrivalManeuverType(routeProgress);
        if (isValidArrivalManeuverType) {
            LegStep currentStep = routeProgress.currentLegProgress().currentStep();
            BannerInstructions currentInstructions = ((BannerInstructionMilestone)milestone).getBannerInstructions();
            List bannerInstructions = currentStep.bannerInstructions();
            if (this.hasValidInstructions(bannerInstructions, currentInstructions)) {
                int lastInstructionIndex = bannerInstructions.size() - 1;
                BannerInstructions lastInstructions = (BannerInstructions)bannerInstructions.get(lastInstructionIndex);
                return currentInstructions.equals(lastInstructions);
            }
        }
        return false;
    }

    public boolean isLastLeg(RouteProgress routeProgress) {
        List legs = routeProgress.directionsRoute().legs();
        RouteLeg currentLeg = routeProgress.currentLeg();
        return currentLeg.equals(legs.get(legs.size() - 1));
    }

    @Nullable
    public List<Point> calculateRemainingWaypoints(RouteProgress routeProgress) {
        int remainingWaypoints;
        if (routeProgress.directionsRoute().routeOptions() == null) {
            return null;
        }
        ArrayList coordinates = new ArrayList(routeProgress.directionsRoute().routeOptions().coordinates());
        int coordinatesSize = coordinates.size();
        if (coordinatesSize < (remainingWaypoints = routeProgress.remainingWaypoints())) {
            return null;
        }
        List<Point> remainingCoordinates = coordinates.subList(coordinatesSize - remainingWaypoints, coordinatesSize);
        return remainingCoordinates;
    }

    @Nullable
    public String[] calculateRemainingWaypointNames(RouteProgress routeProgress) {
        RouteOptions routeOptions = routeProgress.directionsRoute().routeOptions();
        if (routeOptions == null || TextUtils.isEmpty((CharSequence)routeOptions.waypointNames())) {
            return null;
        }
        String allWaypointNames = routeOptions.waypointNames();
        String[] names = allWaypointNames.split(SEMICOLON);
        int coordinatesSize = routeProgress.directionsRoute().routeOptions().coordinates().size();
        String[] remainingWaypointNames = Arrays.copyOfRange(names, coordinatesSize - routeProgress.remainingWaypoints(), coordinatesSize);
        String[] waypointNames = new String[remainingWaypointNames.length + 1];
        waypointNames[0] = names[0];
        System.arraycopy(remainingWaypointNames, 0, waypointNames, 1, remainingWaypointNames.length);
        return waypointNames;
    }

    public Location createFirstLocationFromRoute(DirectionsRoute route) {
        List coordinates = route.routeOptions().coordinates();
        Point origin = (Point)coordinates.get(0);
        Location forcedLocation = new Location(FORCED_LOCATION);
        forcedLocation.setLatitude(origin.latitude());
        forcedLocation.setLongitude(origin.longitude());
        return forcedLocation;
    }

    public boolean isValidRouteProfile(String routeProfile) {
        return !TextUtils.isEmpty((CharSequence)routeProfile) && VALID_PROFILES.contains(routeProfile);
    }

    @Nullable
    public BannerInstructions findCurrentBannerInstructions(LegStep currentStep, double stepDistanceRemaining) {
        if (this.isValidBannerInstructions(currentStep)) {
            List<BannerInstructions> instructions = this.sortBannerInstructions(currentStep.bannerInstructions());
            for (BannerInstructions instruction : instructions) {
                double distanceAlongGeometry = instruction.distanceAlongGeometry();
                if (!(distanceAlongGeometry >= stepDistanceRemaining)) continue;
                return instruction;
            }
            return instructions.get(0);
        }
        return null;
    }

    private boolean isValidBannerInstructions(LegStep currentStep) {
        return this.isValidStep(currentStep) && this.hasInstructions(currentStep.bannerInstructions());
    }

    private List<BannerInstructions> sortBannerInstructions(List<BannerInstructions> instructions) {
        ArrayList<BannerInstructions> sortedInstructions = new ArrayList<BannerInstructions>(instructions);
        Collections.sort(sortedInstructions, new Comparator<BannerInstructions>(){

            @Override
            public int compare(BannerInstructions instructions, BannerInstructions nextInstructions) {
                return Double.compare(instructions.distanceAlongGeometry(), nextInstructions.distanceAlongGeometry());
            }
        });
        return sortedInstructions;
    }

    @Nullable
    public BannerText findCurrentBannerText(LegStep currentStep, double stepDistanceRemaining, boolean findPrimary) {
        BannerInstructions instructions = this.findCurrentBannerInstructions(currentStep, stepDistanceRemaining);
        if (instructions != null) {
            return this.retrievePrimaryOrSecondaryBannerText(findPrimary, instructions);
        }
        return null;
    }

    @Nullable
    public VoiceInstructions findCurrentVoiceInstructions(LegStep currentStep, double stepDistanceRemaining) {
        if (this.isValidVoiceInstructions(currentStep)) {
            List<VoiceInstructions> instructions = this.sortVoiceInstructions(currentStep.voiceInstructions());
            for (VoiceInstructions instruction : instructions) {
                double distanceAlongGeometry = instruction.distanceAlongGeometry();
                if (!(distanceAlongGeometry >= stepDistanceRemaining)) continue;
                return instruction;
            }
            return instructions.get(0);
        }
        return null;
    }

    private boolean isValidVoiceInstructions(LegStep currentStep) {
        return this.isValidStep(currentStep) && this.hasInstructions(currentStep.voiceInstructions());
    }

    private List<VoiceInstructions> sortVoiceInstructions(List<VoiceInstructions> instructions) {
        ArrayList<VoiceInstructions> sortedInstructions = new ArrayList<VoiceInstructions>(instructions);
        Collections.sort(sortedInstructions, new Comparator<VoiceInstructions>(){

            @Override
            public int compare(VoiceInstructions instructions, VoiceInstructions nextInstructions) {
                return Double.compare(instructions.distanceAlongGeometry(), nextInstructions.distanceAlongGeometry());
            }
        });
        return sortedInstructions;
    }

    private boolean upcomingStepIsArrivalManeuverType(@NonNull RouteProgress routeProgress) {
        return routeProgress.currentLegProgress().upComingStep() != null && routeProgress.currentLegProgress().upComingStep().maneuver().type().contains("arrive");
    }

    private boolean currentStepIsArrivalManeuverType(@NonNull RouteProgress routeProgress) {
        return routeProgress.currentLegProgress().currentStep().maneuver().type().contains("arrive");
    }

    private boolean isValidStep(LegStep step) {
        return step != null;
    }

    private <T> boolean hasInstructions(List<T> instructions) {
        return instructions != null && !instructions.isEmpty();
    }

    private <T> int checkValidIndex(List<T> instructions) {
        int instructionIndex = instructions.size() - 1;
        if (instructionIndex < 0) {
            instructionIndex = 0;
        }
        return instructionIndex;
    }

    private boolean hasValidInstructions(List<BannerInstructions> bannerInstructions, BannerInstructions currentInstructions) {
        return bannerInstructions != null && !bannerInstructions.isEmpty() && currentInstructions != null;
    }

    private BannerText retrievePrimaryOrSecondaryBannerText(boolean findPrimary, BannerInstructions instruction) {
        return findPrimary ? instruction.primary() : instruction.secondary();
    }
}

