/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import com.mapbox.api.directions.v5.models.StepIntersection;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.turf.TurfClassification;
import com.mapbox.turf.TurfMeasurement;
import java.util.ArrayList;
import java.util.List;

public final class ToleranceUtils {
    private ToleranceUtils() {
    }

    public static double dynamicRerouteDistanceTolerance(Point snappedPoint, RouteProgress routeProgress, MapboxNavigationOptions navigationOptions) {
        List<StepIntersection> intersections = routeProgress.currentLegProgress().currentStepProgress().intersections();
        if (!intersections.isEmpty()) {
            ArrayList<Point> intersectionsPoints = new ArrayList<Point>();
            for (StepIntersection intersection : intersections) {
                intersectionsPoints.add(intersection.location());
            }
            Point closestIntersection = TurfClassification.nearestPoint((Point)snappedPoint, intersectionsPoints);
            if (closestIntersection.equals((Object)snappedPoint)) {
                return navigationOptions.minimumDistanceBeforeRerouting();
            }
            double distanceToNextIntersection = TurfMeasurement.distance((Point)snappedPoint, (Point)closestIntersection, (String)"meters");
            if (distanceToNextIntersection <= navigationOptions.maneuverZoneRadius()) {
                return navigationOptions.minimumDistanceBeforeRerouting() / 2.0;
            }
        }
        return navigationOptions.minimumDistanceBeforeRerouting();
    }
}

