/*
 * Decompiled with CFR 0.152.
 */
package com.imf.plugin.so;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.utils.FileUtils;
import com.imf.plugin.so.AssetsOutDestManager;
import com.imf.plugin.so.SoFileExtensions;
import com.imf.plugin.so.SoHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000fJ\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/imf/plugin/so/SoFileTransform;", "Lcom/android/build/api/transform/Transform;", "extension", "Lcom/imf/plugin/so/SoFileExtensions;", "intermediatesDir", "Ljava/io/File;", "(Lcom/imf/plugin/so/SoFileExtensions;Ljava/io/File;)V", "getExtension", "()Lcom/imf/plugin/so/SoFileExtensions;", "getIntermediatesDir", "()Ljava/io/File;", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "", "isRetainAllSoFileByVariantName", "variantName", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "file-plugin"})
@SourceDebugExtension(value={"SMAP\nSoFileTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoFileTransform.kt\ncom/imf/plugin/so/SoFileTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2:84\n1855#2,2:85\n1855#2,2:87\n1856#2:89\n1549#2:90\n1620#2,3:91\n*S KotlinDebug\n*F\n+ 1 SoFileTransform.kt\ncom/imf/plugin/so/SoFileTransform\n*L\n40#1:84\n41#1:85,2\n60#1:87,2\n40#1:89\n80#1:90\n80#1:91,3\n*E\n"})
public final class SoFileTransform
extends Transform {
    @NotNull
    private final SoFileExtensions extension;
    @NotNull
    private final File intermediatesDir;

    public SoFileTransform(@NotNull SoFileExtensions extension, @NotNull File intermediatesDir) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)intermediatesDir, (String)"intermediatesDir");
        this.extension = extension;
        this.intermediatesDir = intermediatesDir;
    }

    @NotNull
    public final SoFileExtensions getExtension() {
        return this.extension;
    }

    @NotNull
    public final File getIntermediatesDir() {
        return this.intermediatesDir;
    }

    @NotNull
    public String getName() {
        return "soFileTransform";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Object[] objectArray = new QualifiedContent.ContentType[]{(QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(@Nullable TransformInvocation transformInvocation) {
        Collection collection;
        super.transform(transformInvocation);
        if (transformInvocation == null) {
            return;
        }
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        if (!this.isIncremental()) {
            outputProvider.deleteAll();
        }
        String variantName = transformInvocation.getContext().getVariantName();
        boolean isRetainAll = false;
        Intrinsics.checkNotNullExpressionValue((Object)variantName, (String)"variantName");
        isRetainAll = this.isRetainAllSoFileByVariantName(variantName);
        if (!isRetainAll && ((collection = (Collection)this.extension.getDeleteSoLibs()) == null || collection.isEmpty()) && ((collection = (Collection)this.extension.getCompressSo2AssetsLibs()) == null || collection.isEmpty())) {
            isRetainAll = true;
        }
        SoHandle soHandle2 = new SoHandle(this.extension, new AssetsOutDestManager(variantName, this.intermediatesDir));
        System.out.println((Object)("isRetainAll:" + isRetainAll));
        ExecutorService executor = Executors.newFixedThreadPool(10);
        Collection collection2 = transformInvocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"transformInvocation.inputs");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dest;
            TransformInput input = (TransformInput)element$iv;
            boolean bl = false;
            Collection collection3 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"input.directoryInputs");
            Iterable $this$forEach$iv2 = collection3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File dir;
                DirectoryInput directoryInput = (DirectoryInput)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY), (String)"outputProvider.getConten\u2026RECTORY\n                )");
                Intrinsics.checkNotNullExpressionValue((Object)directoryInput.getFile(), (String)"directoryInput.file");
                if (!dir.exists() || !dir.isDirectory()) continue;
                File file = new File(dir, "lib");
                if (isRetainAll || !file.exists()) {
                    FileUtils.copyDirectory((File)directoryInput.getFile(), (File)dest);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"executor");
                soHandle2.perform7z(file, executor, new File(dest, "lib"));
            }
            Collection collection4 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"input.jarInputs");
            $this$forEach$iv2 = collection4;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR), (String)"outputProvider.getConten\u2026mat.JAR\n                )");
                executor.execute(new Runnable(jarInput, dest){
                    final /* synthetic */ JarInput $jarInput;
                    final /* synthetic */ File $dest;
                    {
                        this.$jarInput = $jarInput;
                        this.$dest = $dest;
                    }

                    public final void run() {
                        FileUtils.copyFile((File)this.$jarInput.getFile(), (File)this.$dest);
                    }
                });
            }
        }
        executor.shutdown();
        soHandle2.resultWriteToFile();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRetainAllSoFileByVariantName(@NotNull String variantName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Set<String> set = this.extension.getExcludeBuildTypes();
        if (set != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                collection.add(string2);
            }
            List list = (List)destination$iv$iv;
            String string = variantName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            bl = list.contains(string);
        } else {
            bl = false;
        }
        return bl;
    }
}

