/*
 * Decompiled with CFR 0.152.
 */
package com.imf.plugin.so;

import com.android.utils.FileUtils;
import com.imf.plugin.so.AssetsOutDestManager;
import com.imf.plugin.so.SoFileExtensions;
import com.imf.plugin.so.SoHandle;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/imf/plugin/so/SoFileVariantAction;", "Lorg/gradle/api/Action;", "", "variantName", "", "extension", "Lcom/imf/plugin/so/SoFileExtensions;", "intermediatesDir", "Ljava/io/File;", "(Ljava/lang/String;Lcom/imf/plugin/so/SoFileExtensions;Ljava/io/File;)V", "getExtension", "()Lcom/imf/plugin/so/SoFileExtensions;", "getIntermediatesDir", "()Ljava/io/File;", "getVariantName", "()Ljava/lang/String;", "buildMergedNativeLibsFile", "execute", "", "input", "file-plugin"})
public final class SoFileVariantAction
implements Action<Object> {
    @NotNull
    private final String variantName;
    @NotNull
    private final SoFileExtensions extension;
    @NotNull
    private final File intermediatesDir;

    public SoFileVariantAction(@NotNull String variantName, @NotNull SoFileExtensions extension, @NotNull File intermediatesDir) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)intermediatesDir, (String)"intermediatesDir");
        this.variantName = variantName;
        this.extension = extension;
        this.intermediatesDir = intermediatesDir;
    }

    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @NotNull
    public final SoFileExtensions getExtension() {
        return this.extension;
    }

    @NotNull
    public final File getIntermediatesDir() {
        return this.intermediatesDir;
    }

    public void execute(@NotNull Object input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        SoHandle soHandle2 = new SoHandle(this.extension, new AssetsOutDestManager(this.variantName, this.intermediatesDir));
        File mergedNativeLibsFile = this.buildMergedNativeLibsFile(this.variantName);
        soHandle2.singlePerform7z(mergedNativeLibsFile, null);
    }

    @NotNull
    public final File buildMergedNativeLibsFile(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        String[] stringArray = new String[]{"merged_native_libs", variantName, "out", "lib"};
        File file = FileUtils.join((File)this.intermediatesDir, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(intermediatesDir, \"\u2026ariantName, \"out\", \"lib\")");
        return file;
    }
}

