/*
 * Decompiled with CFR 0.152.
 */
package com.mainli.apk;

import com.android.apksig.ApkSigner;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.model.SigningConfig;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ApkSign {
    public static File sign(File inputApk, ApkVariant variant) {
        return ApkSign.sign(inputApk, variant.getSigningConfig(), (Integer)((PackageAndroidArtifact)variant.getPackageApplicationProvider().get()).getMinSdkVersion().get());
    }

    public static File sign(File inputApk, SigningConfig signingConfig, int minSdkVersion) {
        File keystoreFile = signingConfig.getStoreFile();
        String keystorePassworld = signingConfig.getStorePassword();
        String keystoreAlias = signingConfig.getKeyAlias();
        String keystoreAliasPassworld = signingConfig.getKeyPassword();
        File outputApk = new File(inputApk.getParentFile(), "_single.apk");
        if (outputApk.exists()) {
            boolean bl = outputApk.delete();
        }
        String defaultType = KeyStore.getDefaultType();
        try {
            KeyStore ks = KeyStore.getInstance(defaultType);
            ApkSign.loadKeyStoreFromFile(ks, keystoreFile, keystorePassworld);
            if (ks.isKeyEntry(keystoreAlias)) {
                Certificate[] certChain = ks.getCertificateChain(keystoreAlias);
                PrivateKey privateKey = (PrivateKey)ks.getKey(keystoreAlias, keystoreAliasPassworld.toCharArray());
                ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(certChain.length);
                for (Certificate cert : certChain) {
                    certs.add((X509Certificate)cert);
                }
                String v1SigBasename = null;
                String keyFileName = keystoreFile.getName();
                int delimiterIndex = keyFileName.indexOf(46);
                v1SigBasename = delimiterIndex == -1 ? keyFileName : keyFileName.substring(0, delimiterIndex);
                ApkSigner.SignerConfig signerConfig = new ApkSigner.SignerConfig.Builder(v1SigBasename, privateKey, certs).build();
                ApkSigner.Builder apkSignerBuilder = new ApkSigner.Builder(Arrays.asList(signerConfig)).setInputApk(inputApk).setOutputApk(outputApk).setOtherSignersSignaturesPreserved(false).setV1SigningEnabled(signingConfig.isV1SigningEnabled()).setV2SigningEnabled(signingConfig.isV2SigningEnabled()).setV3SigningEnabled(signingConfig.isV2SigningEnabled());
                apkSignerBuilder.setMinSdkVersion(minSdkVersion);
                ApkSigner apkSigner = apkSignerBuilder.build();
                try {
                    apkSigner.sign();
                    return outputApk;
                }
                catch (Exception exception) {}
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void loadKeyStoreFromFile(KeyStore ks, File file, String passwordStr) throws Exception {
        List<char[]> passwords = Arrays.asList(new char[][]{passwordStr.toCharArray()});
        Exception lastFailure = null;
        for (char[] password : passwords) {
            try {
                try (FileInputStream in = new FileInputStream(file);){
                    ks.load(in, password);
                }
                return;
            }
            catch (Exception e) {
                lastFailure = e;
            }
        }
        if (lastFailure == null) {
            throw new RuntimeException("No keystore passwords");
        }
        throw lastFailure;
    }
}

