/*
 * Decompiled with CFR 0.152.
 */
package com.mainli.apk;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    @NotNull
    public static File join(@NotNull File files, String ... paths) {
        File tmp = files;
        for (String path : paths) {
            tmp = new File(tmp, path);
        }
        return tmp;
    }

    public static void copyDir(File srcFile, File descFile) throws Exception {
        File[] files = srcFile.listFiles();
        if (files == null) {
            FileUtils.makeDir(srcFile, descFile);
            return;
        }
        FileUtils.makeDir(srcFile, descFile);
        String s = descFile.getParent() == null ? descFile.getPath() + srcFile.getName() : descFile.getPath() + "/" + srcFile.getName();
        descFile = new File(s);
        for (File value : files) {
            if (value.isFile()) {
                Files.copy(value.toPath(), descFile.toPath(), new CopyOption[0]);
                continue;
            }
            FileUtils.copyDir(value, descFile);
        }
    }

    private static void makeDir(File srcFile, File descFile) {
        String s = descFile.getParent() == null ? descFile.getPath() + srcFile.getName() : descFile.getPath() + "/" + srcFile.getName();
        File newDir = new File(s);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
    }
}

