/*
 * Decompiled with CFR 0.152.
 */
package com.mainli.apk;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int BUFFERSIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File appendFile(File apk, String prefix, File file) {
        if (apk == null || !apk.exists() || file == null || !file.exists()) {
            return null;
        }
        File outPutApk = new File(apk.getParentFile(), "_appendFileUnsigned.apk");
        ZipFile inputZip = null;
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            inputZip = new ZipFile(apk);
            Enumeration<? extends ZipEntry> entries = inputZip.entries();
            fileOutputStream = new FileOutputStream(outPutApk);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            while (entries.hasMoreElements()) {
                ZipUtil.addZipFile2ZipOutputStream(inputZip, entries.nextElement(), zipOutputStream);
            }
            StringBuilder builder = new StringBuilder(prefix);
            if (builder.charAt(builder.length() - 1) == '/') {
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append('/').append(file.getName());
            if (file.isDirectory()) {
                builder.append('/');
            }
            ZipUtil.addFile2ZipOutputStream(file, builder.toString(), zipOutputStream);
            zipOutputStream.flush();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                outPutApk = null;
            }
            catch (Throwable throwable) {
                ZipUtil.close(inputZip);
                ZipUtil.close(zipOutputStream);
                throw throwable;
            }
            ZipUtil.close(inputZip);
            ZipUtil.close(zipOutputStream);
        }
        ZipUtil.close(inputZip);
        ZipUtil.close(zipOutputStream);
        return outPutApk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addZipFile2ZipOutputStream(ZipFile inputZip, ZipEntry sourceZipEntry, ZipOutputStream zipOutputStream) {
        InputStream is = null;
        try {
            is = inputZip.getInputStream(sourceZipEntry);
            int len = 0;
            zipOutputStream.putNextEntry(new ZipEntry(sourceZipEntry.getName()));
            byte[] bufer = new byte[1024];
            while ((len = is.read(bufer)) > 0) {
                zipOutputStream.write(bufer, 0, len);
            }
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ZipUtil.close(is);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFile2ZipOutputStream(File file, String relativePath, ZipOutputStream zos) {
        FileInputStream is = null;
        try {
            if (!file.exists()) {
                return;
            }
            if (!file.isDirectory()) {
                ZipEntry zp = new ZipEntry(relativePath);
                zos.putNextEntry(zp);
                is = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = ((InputStream)is).read(buffer)) >= 0) {
                    zos.write(buffer, 0, length);
                }
                zos.flush();
                zos.closeEntry();
            } else {
                String tempPath = null;
                for (File f : file.listFiles()) {
                    tempPath = relativePath + f.getName();
                    if (f.isDirectory()) {
                        tempPath = tempPath + "/";
                    }
                    ZipUtil.addFile2ZipOutputStream(f, tempPath, zos);
                }
            }
            ZipUtil.close(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ZipUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unZipFile(ZipFile inputZip, ZipEntry sourceZipEntry, File dir) {
        block8: {
            File file;
            if (inputZip == null || sourceZipEntry == null || dir == null) {
                return null;
            }
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = inputZip.getInputStream(sourceZipEntry);
                int len = 0;
                File file2 = new File(dir, sourceZipEntry.getName());
                File parentFile = file2.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                outputStream = new FileOutputStream(file2);
                byte[] bufer = new byte[1024];
                while ((len = inputStream.read(bufer)) > 0) {
                    outputStream.write(bufer, 0, len);
                }
                outputStream.flush();
                file = file2;
                ZipUtil.close(outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                ZipUtil.close(outputStream);
                ZipUtil.close(inputStream);
            }
            ZipUtil.close(inputStream);
            return file;
        }
        return null;
    }
}

