/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyukhalov.polylabel;

import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.geojson.Polygon;
import com.mapbox.services.commons.models.Position;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class Polylabel {
    public static Point polylabel(Polygon polygon, double precision) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        List outerRingCoordinates = (List)polygon.getCoordinates().get(0);
        for (Position p : outerRingCoordinates) {
            double lon = p.getLongitude();
            double lat = p.getLatitude();
            minX = StrictMath.min(minX, lon);
            minY = StrictMath.min(minY, lat);
            maxX = StrictMath.max(maxX, lon);
            maxY = StrictMath.max(maxY, lat);
        }
        double width = maxX - minX;
        double height = maxY - minY;
        double cellSize = Math.min(width, height);
        double h = cellSize / 2.0;
        if (cellSize == 0.0) {
            return Point.fromCoordinates((double[])new double[]{minX, minY});
        }
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>(new CellComparator());
        for (double x = minX; x < maxX; x += cellSize) {
            for (double y = minY; y < maxY; y += cellSize) {
                cellQueue.add(new Cell(x + h, y + h, h, polygon));
            }
        }
        Cell bestCell = Polylabel.getCentroidCell(polygon);
        Cell bboxCell = new Cell(minX + width / 2.0, minY + height / 2.0, 0.0, polygon);
        if (bboxCell.d > bestCell.d) {
            bestCell = bboxCell;
        }
        while (!cellQueue.isEmpty()) {
            Cell cell = cellQueue.poll();
            if (cell.d > bestCell.d) {
                bestCell = cell;
            }
            if (cell.max - bestCell.d <= precision) continue;
            h = cell.h / 2.0;
            cellQueue.add(new Cell(cell.x - h, cell.y - h, h, polygon));
            cellQueue.add(new Cell(cell.x + h, cell.y - h, h, polygon));
            cellQueue.add(new Cell(cell.x - h, cell.y + h, h, polygon));
            cellQueue.add(new Cell(cell.x + h, cell.y + h, h, polygon));
        }
        return Point.fromCoordinates((double[])new double[]{bestCell.x, bestCell.y});
    }

    private static Cell getCentroidCell(Polygon polygon) {
        double area = 0.0;
        double x = 0.0;
        double y = 0.0;
        List points = (List)polygon.getCoordinates().get(0);
        int i = 0;
        int len = points.size();
        int j = len - 1;
        while (i < len) {
            Position a = (Position)points.get(i);
            Position b = (Position)points.get(j);
            double aLon = a.getLongitude();
            double aLat = a.getLatitude();
            double bLon = b.getLongitude();
            double bLat = b.getLatitude();
            double f = aLon * bLat - bLon * aLat;
            x += (aLon + bLon) * f;
            y += (aLat + bLat) * f;
            area += f * 3.0;
            j = i++;
        }
        if (area == 0.0) {
            Position p = (Position)points.get(0);
            return new Cell(p.getLongitude(), p.getLatitude(), 0.0, polygon);
        }
        return new Cell(x / area, y / area, 0.0, polygon);
    }

    private static class Cell {
        private final double x;
        private final double y;
        private final double h;
        private final double d;
        private final double max;

        private Cell(double x, double y, double h, Polygon polygon) {
            this.x = x;
            this.y = y;
            this.h = h;
            this.d = this.pointToPolygonDist(x, y, polygon);
            this.max = this.d + this.h * Math.sqrt(2.0);
        }

        private double pointToPolygonDist(double x, double y, Polygon polygon) {
            boolean inside = false;
            double minDistSq = Double.MAX_VALUE;
            for (List ring : polygon.getCoordinates()) {
                int i = 0;
                int len = ring.size();
                int j = len - 1;
                while (i < len) {
                    double bLat;
                    Position a = (Position)ring.get(i);
                    Position b = (Position)ring.get(j);
                    double aLon = a.getLongitude();
                    double aLat = a.getLatitude();
                    double bLon = b.getLongitude();
                    if (aLat > y != (bLat = b.getLatitude()) > y && x < (bLon - aLon) * (y - aLat) / (bLat - aLat) + aLon) {
                        inside = !inside;
                    }
                    minDistSq = Math.min(minDistSq, this.getSegDistSq(x, y, a, b));
                    j = i++;
                }
            }
            return (double)(inside ? 1 : -1) * Math.sqrt(minDistSq);
        }

        private double getSegDistSq(double px, double py, Position a, Position b) {
            double x = a.getLongitude();
            double y = a.getLatitude();
            double dx = b.getLongitude() - x;
            double dy = b.getLatitude() - y;
            if (dx != 0.0 || dy != 0.0) {
                double t = ((px - x) * dx + (py - y) * dy) / (dx * dx + dy * dy);
                if (t > 1.0) {
                    x = b.getLongitude();
                    y = b.getLatitude();
                } else if (t > 0.0) {
                    x += dx * t;
                    y += dy * t;
                }
            }
            dx = px - x;
            dy = py - y;
            return dx * dx + dy * dy;
        }
    }

    private static class CellComparator
    implements Comparator<Cell> {
        private CellComparator() {
        }

        @Override
        public int compare(Cell o1, Cell o2) {
            return Double.compare(o2.max, o1.max);
        }
    }
}

