/*
 * Decompiled with CFR 0.152.
 */
package com.solodroid.push.sdk.provider;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import com.onesignal.OneSignal;
import com.onesignal.debug.LogLevel;
import com.onesignal.notifications.INotification;
import com.solodroid.push.sdk.utils.OnNotificationClickListener;
import org.json.JSONObject;

public class OneSignalPush {
    public static final int NOTIFICATION_PERMISSION_REQUEST_CODE = 22;
    public static String EXTRA_ID = "id";
    public static String EXTRA_TITLE = "title";
    public static String EXTRA_MESSAGE = "message";
    public static String EXTRA_IMAGE = "image";
    public static String EXTRA_LAUNCH_URL = "launch_url";
    public static String EXTRA_UNIQUE_ID = "unique_id";
    public static String EXTRA_POST_ID = "post_id";
    public static String EXTRA_LINK = "link";

    public static class AdditionalData {
        public static String uniqueId = "";
        public static String postId = "";
        public static int postID;
        public static String link;

        static {
            link = "";
        }
    }

    public static class Data {
        public static String id = "";
        public static String title = "";
        public static String message = "";
        public static String bigImage = "";
        public static String launchUrl = "";
    }

    public static class Builder {
        private static final String TAG = "OneSignalPush";
        Context context;
        private String oneSignalAppId = "";
        private String notificationId = "";
        private String notificationTitle = "";
        private String notificationMessage = "";
        private String notificationBigImage = "";
        private String notificationLaunchUrl = "";
        private String uniqueId = "";
        private String postId = "";
        private int postID;
        private String link = "";

        public Builder(Context context) {
            this.context = context;
        }

        public Builder build(OnNotificationClickListener onNotificationClickListener) {
            this.initNotification(onNotificationClickListener);
            return this;
        }

        public Builder create(OnNotificationClickListener onNotificationClickListener) {
            this.buildNotification(onNotificationClickListener);
            return this;
        }

        public Builder setOneSignalAppId(String oneSignalAppId) {
            this.oneSignalAppId = oneSignalAppId;
            return this;
        }

        public void initNotification(OnNotificationClickListener onNotificationClickListener) {
            OneSignal.getDebug().setLogLevel(LogLevel.VERBOSE);
            OneSignal.initWithContext((Context)this.context, (String)this.oneSignalAppId);
            OneSignal.getUser().getPushSubscription().optIn();
            OneSignal.getNotifications().addClickListener(result -> {
                INotification notification = result.getNotification();
                JSONObject data = notification.getAdditionalData();
                this.notificationId = result.getNotification().getNotificationId();
                this.notificationTitle = result.getNotification().getTitle();
                this.notificationMessage = result.getNotification().getBody();
                this.notificationBigImage = result.getNotification().getBigPicture();
                this.notificationLaunchUrl = result.getNotification().getLaunchURL();
                Data.id = this.notificationId;
                Data.title = this.notificationTitle;
                Data.message = this.notificationMessage;
                Data.bigImage = this.notificationBigImage;
                Data.launchUrl = this.notificationLaunchUrl;
                try {
                    if (data != null) {
                        this.uniqueId = data.getString(EXTRA_UNIQUE_ID);
                        this.postId = data.getString(EXTRA_POST_ID);
                        this.link = data.getString(EXTRA_LINK);
                        AdditionalData.uniqueId = this.uniqueId;
                        AdditionalData.postId = this.postId;
                        AdditionalData.link = this.link;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.d((String)TAG, (String)("error: " + e.getMessage()));
                }
                onNotificationClickListener.onComplete();
            });
        }

        public void buildNotification(OnNotificationClickListener onNotificationClickListener) {
            OneSignal.getDebug().setLogLevel(LogLevel.VERBOSE);
            OneSignal.initWithContext((Context)this.context, (String)this.oneSignalAppId);
            OneSignal.getUser().getPushSubscription().optIn();
            OneSignal.getNotifications().addClickListener(result -> {
                INotification notification = result.getNotification();
                JSONObject data = notification.getAdditionalData();
                this.notificationId = result.getNotification().getNotificationId();
                this.notificationTitle = result.getNotification().getTitle();
                this.notificationMessage = result.getNotification().getBody();
                this.notificationBigImage = result.getNotification().getBigPicture();
                this.notificationLaunchUrl = result.getNotification().getLaunchURL();
                Data.id = this.notificationId;
                Data.title = this.notificationTitle;
                Data.message = this.notificationMessage;
                Data.bigImage = this.notificationBigImage;
                Data.launchUrl = this.notificationLaunchUrl;
                try {
                    if (data != null) {
                        AdditionalData.postID = this.postID = data.getInt(EXTRA_POST_ID);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.d((String)TAG, (String)("error: " + e.getMessage()));
                }
                onNotificationClickListener.onComplete();
            });
        }

        public void requestNotificationPermission() {
            if (Build.VERSION.SDK_INT >= 33 && this.context.checkSelfPermission("android.permission.POST_NOTIFICATIONS") != 0) {
                ActivityCompat.requestPermissions((Activity)((Activity)this.context), (String[])new String[]{"android.permission.POST_NOTIFICATIONS"}, (int)22);
            }
        }
    }
}

