/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.css;

import android.text.TextUtils;
import br.tiagohm.markdownview.css.StyleSheet;
import com.orhanobut.logger.Logger;
import java.util.LinkedHashMap;
import java.util.Map;

public class InternalStyleSheet
implements StyleSheet {
    private static final String NO_MEDIA_QUERY = "NO_MEDIA_QUERY";
    private Map<String, Map<String, Map<String, String>>> mRules = new LinkedHashMap<String, Map<String, Map<String, String>>>();
    private String currentMediaQuery = "NO_MEDIA_QUERY";

    public InternalStyleSheet() {
        this.mRules.put(this.currentMediaQuery, new LinkedHashMap());
    }

    private Map<String, Map<String, String>> getCurrentMediaQuery() {
        return this.mRules.get(this.currentMediaQuery);
    }

    public void addMedia(String mediaQuery) {
        if (mediaQuery != null && mediaQuery.trim().length() > 0 && !this.mRules.containsKey(mediaQuery = mediaQuery.trim())) {
            this.mRules.put(mediaQuery, new LinkedHashMap());
            this.currentMediaQuery = mediaQuery;
        }
    }

    public void endMedia() {
        this.currentMediaQuery = NO_MEDIA_QUERY;
    }

    public void addRule(String selector, String ... declarations) {
        if (selector != null && selector.trim().length() > 0 && declarations.length > 0) {
            selector = selector.trim();
            if (!this.getCurrentMediaQuery().containsKey(selector)) {
                this.getCurrentMediaQuery().put(selector, new LinkedHashMap());
            }
            for (String declaration : declarations) {
                if (declaration == null || declaration.trim().length() <= 0) continue;
                String[] nameAndValue = declaration.trim().split(":");
                if (nameAndValue.length == 2) {
                    String name = nameAndValue[0].trim();
                    String value = nameAndValue[1].trim();
                    this.getCurrentMediaQuery().get(selector).put(name, value);
                    continue;
                }
                Logger.e((String)("invalid css: '" + declaration + "' in selector: " + selector), (Object[])new Object[0]);
            }
        }
    }

    public void removeRule(String selector) {
        this.getCurrentMediaQuery().remove(selector);
    }

    public void removeDeclaration(String selector, String declarationName) {
        if (!TextUtils.isEmpty((CharSequence)selector) && this.getCurrentMediaQuery().containsKey(selector)) {
            this.getCurrentMediaQuery().get(selector).remove(declarationName);
        }
    }

    public void replaceDeclaration(String selector, String declarationName, String newDeclarationValue) {
        if (!TextUtils.isEmpty((CharSequence)selector) && !TextUtils.isEmpty((CharSequence)declarationName) && this.getCurrentMediaQuery().containsKey(selector) && this.getCurrentMediaQuery().get(selector).containsKey(declarationName)) {
            this.getCurrentMediaQuery().get(selector).put(declarationName, newDeclarationValue);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, Map<String, String>>> q : this.mRules.entrySet()) {
            if (!q.getKey().equals(NO_MEDIA_QUERY)) {
                sb.append("@media ");
                sb.append(q.getKey());
                sb.append(" {\n");
            }
            for (Map.Entry<String, Map<String, String>> e : q.getValue().entrySet()) {
                sb.append(e.getKey());
                sb.append(" {");
                for (Map.Entry<String, String> declaration : e.getValue().entrySet()) {
                    sb.append(declaration.getKey());
                    sb.append(":");
                    sb.append(declaration.getValue());
                    sb.append(";");
                }
                sb.append("}\n");
            }
            if (q.getKey().equals(NO_MEDIA_QUERY)) continue;
            sb.append("}\n");
        }
        return sb.toString();
    }

    @Override
    public String toHTML() {
        return "<style>\n" + this.toString() + "\n</style>\n";
    }
}

