/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.ext.emoji.internal;

import br.tiagohm.markdownview.ext.emoji.Emoji;
import br.tiagohm.markdownview.ext.emoji.EmojiExtension;
import br.tiagohm.markdownview.ext.emoji.internal.EmojiCheatSheet;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class EmojiNodeRenderer
implements NodeRenderer {
    private final String rootImagePath;
    private final String attrImageSize;
    private final String attrAlign;
    private final String extImage;

    public EmojiNodeRenderer(DataHolder options) {
        this.rootImagePath = (String)options.get(EmojiExtension.ROOT_IMAGE_PATH);
        this.attrImageSize = (String)options.get(EmojiExtension.ATTR_IMAGE_SIZE);
        this.attrAlign = (String)options.get(EmojiExtension.ATTR_ALIGN);
        this.extImage = (String)options.get(EmojiExtension.IMAGE_EXT);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Emoji.class, (CustomNodeRenderer)new CustomNodeRenderer<Emoji>(){

            public void render(Emoji node, NodeRendererContext context, HtmlWriter html) {
                EmojiNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(Emoji node, NodeRendererContext context, HtmlWriter html) {
        Emoji emoji = node;
        EmojiCheatSheet.EmojiShortcut shortcut = EmojiCheatSheet.getImageShortcut(emoji.getText().toString());
        if (shortcut == null) {
            html.text((CharSequence)":");
            context.renderChildren((Node)node);
            html.text((CharSequence)":");
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)(this.rootImagePath + shortcut.image + "." + this.extImage), null);
            html.attr((CharSequence)"src", (CharSequence)resolvedLink.getUrl());
            html.attr((CharSequence)"alt", (CharSequence)("emoji " + shortcut.category + ":" + shortcut.name));
            if (!this.attrImageSize.isEmpty()) {
                ((HtmlWriter)html.attr((CharSequence)"height", (CharSequence)this.attrImageSize)).attr((CharSequence)"width", (CharSequence)this.attrImageSize);
            }
            if (!this.attrAlign.isEmpty()) {
                html.attr((CharSequence)"align", (CharSequence)this.attrAlign);
            }
            html.withAttr(resolvedLink);
            html.tagVoid((CharSequence)"img");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new EmojiNodeRenderer(options);
        }
    }
}

