/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.ext.twitter.internal;

import android.os.ConditionVariable;
import android.text.TextUtils;
import br.tiagohm.markdownview.Utils;
import br.tiagohm.markdownview.ext.twitter.Twitter;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;

public class TwitterNodeRenderer
implements NodeRenderer {
    private ConditionVariable mCondition = new ConditionVariable(false);
    private String mHtml = null;

    public TwitterNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Twitter.class, (CustomNodeRenderer)new CustomNodeRenderer<Twitter>(){

            public void render(Twitter node, NodeRendererContext context, HtmlWriter html) {
                TwitterNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(Twitter node, NodeRendererContext context, HtmlWriter html) {
        String name = node.getText().toString();
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else if (!TextUtils.isEmpty((CharSequence)name)) {
            String url;
            String value;
            try {
                value = URLEncoder.encode(context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), null).getUrl(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                context.renderChildren((Node)node);
                return;
            }
            if (name.equals("tweet")) {
                url = String.format("https://publish.twitter.com/oembed?url=https://twitter.com/twitter/status/%s", value);
            } else if (name.equals("tweet-hide-cards")) {
                url = String.format("https://publish.twitter.com/oembed?url=https://twitter.com/twitter/status/%s&hide_media=true", value);
            } else {
                if (name.equals("follow")) {
                    this.mHtml = String.format("<a href=\"https://twitter.com/%s\" data-size=\"large\" class=\"twitter-follow-button\" data-show-count=\"true\">Follow @%s</a><script async src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>", value, value);
                    html.srcPos(node.getChars()).append((CharSequence)this.mHtml);
                    return;
                }
                context.renderChildren((Node)node);
                return;
            }
            this.mHtml = null;
            new Thread(new LoadTweetRunnable(url)).start();
            this.mCondition.close();
            this.mCondition.block();
            if (this.mHtml == null) {
                context.renderChildren((Node)node);
            } else {
                this.mHtml = this.mHtml.replaceAll("src=\"//", "src=\"https://");
                html.srcPos(node.getChars()).append((CharSequence)this.mHtml);
            }
        }
    }

    private class LoadTweetRunnable
    implements Runnable {
        private String mUrl;

        public LoadTweetRunnable(String url) {
            this.mUrl = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream is = null;
            try {
                URLConnection connection = new URL(this.mUrl).openConnection();
                connection.setReadTimeout(5000);
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("Accept-Charset", "UTF-8");
                is = connection.getInputStream();
                String json = Utils.getStringFromInputStream(is);
                if (!TextUtils.isEmpty((CharSequence)json)) {
                    JSONObject tweet = new JSONObject(json);
                    TwitterNodeRenderer.this.mHtml = tweet.getString("html");
                } else {
                    TwitterNodeRenderer.this.mHtml = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                TwitterNodeRenderer.this.mCondition.open();
            }
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new TwitterNodeRenderer(options);
        }
    }
}

