/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.spatial.AbstractSpatialSBasePlugin;
import org.sbml.jsbml.ext.spatial.SpatialCompartmentPlugin;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.util.XMLResourceBundleControl;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;

public class SpatialSpeciesPlugin
extends AbstractSpatialSBasePlugin {
    private static final long serialVersionUID = 1636970127352490380L;
    private Boolean spatial;
    private static final ResourceBundle bundle = new XMLResourceBundleControl.XMLResourceSpatial();

    public SpatialSpeciesPlugin() {
    }

    public SpatialSpeciesPlugin(Species sp) {
        super((SBase)sp);
    }

    public SpatialSpeciesPlugin(SpatialSpeciesPlugin sb) {
        super(sb);
        if (sb.isSetSpatial()) {
            this.setSpatial(sb.isSpatial());
        }
    }

    @Override
    public SpatialSpeciesPlugin clone() {
        return new SpatialSpeciesPlugin(this);
    }

    public Species getExtendedSBase() {
        if (this.isSetExtendedSBase()) {
            return (Species)super.getExtendedSBase();
        }
        return null;
    }

    public boolean getSpatial() {
        return this.spatial;
    }

    public int hashCode() {
        int prime = 997;
        int hashCode = super.hashCode();
        if (this.isSetSpatial()) {
            hashCode += 997 * this.spatial.hashCode();
        }
        return hashCode;
    }

    public boolean isSetSpatial() {
        return this.spatial != null;
    }

    public boolean isSpatial() {
        return this.getSpatial();
    }

    public void setSpatial(boolean isSpatial) {
        SpatialCompartmentPlugin spatialCompartment;
        boolean cmSet;
        Species species;
        Compartment compartment;
        this.spatial = isSpatial;
        if (this.isSetExtendedSBase() && (compartment = (species = this.getExtendedSBase()).getCompartmentInstance()) != null && !(cmSet = (spatialCompartment = (SpatialCompartmentPlugin)compartment.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1")).isSetCompartmentMapping())) {
            throw new SBMLException(bundle.getString("COMPARTMENT_MAPPING_NOT_SET"));
        }
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("isSpatial")) {
                try {
                    this.setSpatial(StringTools.parseSBMLBooleanStrict((String)value));
                }
                catch (Exception e) {
                    AbstractReaderWriter.processInvalidAttribute((String)attributeName, null, (String)value, (String)prefix, (Object)((Object)this));
                    throw new SBMLException(MessageFormat.format(bundle.getString("COULD_NOT_READ"), value, "isSpatial"));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetSpatial()) {
            attributes.put("spatial:isSpatial", this.spatial.toString());
        }
        return attributes;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            SpatialSpeciesPlugin species = (SpatialSpeciesPlugin)((Object)object);
            equal &= species.isSetSpatial() == this.isSetSpatial();
            equal &= species.getSpatial() == this.getSpatial();
        }
        return equal;
    }
}

