/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ext.spatial.AdvectionCoefficient;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class AdvectionCoefficientConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1223501, 1223505);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1223501: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1223502: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1223503: {
                func = new UnknownPackageAttributeValidationFunction<AdvectionCoefficient>("spatial"){

                    public boolean check(ValidationContext ctx, AdvectionCoefficient ac) {
                        if (!ac.isSetVariable()) {
                            return false;
                        }
                        if (!ac.isSetCoordinate()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)ac);
                    }
                };
                break;
            }
            case 1223504: {
                func = new ValidationFunction<AdvectionCoefficient>(){

                    public boolean check(ValidationContext ctx, AdvectionCoefficient ac) {
                        if (ac.isSetVariable()) {
                            Model m = ac.getModel();
                            return m.getSpecies(ac.getVariable()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223505: {
                func = new InvalidAttributeValidationFunction("coordinate");
            }
        }
        return func;
    }
}

