/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ext.spatial.Boundary;
import org.sbml.jsbml.ext.spatial.BoundaryCondition;
import org.sbml.jsbml.ext.spatial.CoordinateComponent;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class BoundaryConditionConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1223601, 1223607);
                set.add(1223650);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1223601: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1223602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1223603: {
                func = new UnknownPackageAttributeValidationFunction<BoundaryCondition>("spatial"){

                    public boolean check(ValidationContext ctx, BoundaryCondition bc) {
                        if (!bc.isSetVariable()) {
                            return false;
                        }
                        if (!bc.isSetType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)bc);
                    }
                };
                break;
            }
            case 1223604: {
                func = new ValidationFunction<BoundaryCondition>(){

                    public boolean check(ValidationContext ctx, BoundaryCondition bc) {
                        if (bc.isSetVariable()) {
                            Model m = bc.getModel();
                            return m.getSpecies(bc.getVariable()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223605: {
                func = new InvalidAttributeValidationFunction("type");
                break;
            }
            case 1223606: {
                func = new ValidationFunction<BoundaryCondition>(){

                    public boolean check(ValidationContext ctx, BoundaryCondition bc) {
                        if (bc.isSetCoordinateBoundary()) {
                            Geometry g = bc.getGeometryInstance();
                            ListOf<CoordinateComponent> locc = g.getListOfCoordinateComponents();
                            for (CoordinateComponent cc : locc) {
                                Boundary b1 = (Boundary)((Object)cc.getChildAt(0));
                                Boundary b2 = (Boundary)((Object)cc.getChildAt(1));
                                if (b1.getId().compareTo(bc.getCoordinateBoundary()) != 0 && b2.getId().compareTo(bc.getCoordinateBoundary()) != 0) continue;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223607: {
                func = new ValidationFunction<BoundaryCondition>(){

                    public boolean check(ValidationContext ctx, BoundaryCondition bc) {
                        if (bc.isSetBoundaryDomainType()) {
                            Geometry g = bc.getGeometryInstance();
                            return g.getDomainType(bc.getBoundaryDomainType()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223650: {
                func = new ValidationFunction<BoundaryCondition>(){

                    public boolean check(ValidationContext ctx, BoundaryCondition bc) {
                        return !bc.isSetCoordinateBoundary() || !bc.isSetBoundaryDomainType();
                    }
                };
            }
        }
        return func;
    }
}

