/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.CSGObject;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class CSGObjectConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1222301, 1222307);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1222301: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1222302: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1222303: {
                func = new UnknownPackageAttributeValidationFunction<CSGObject>("spatial"){

                    public boolean check(ValidationContext ctx, CSGObject csgobject) {
                        if (!csgobject.isSetId()) {
                            return false;
                        }
                        if (!csgobject.isSetDomainType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)csgobject);
                    }
                };
                break;
            }
            case 1222304: {
                func = new ValidationFunction<CSGObject>(){

                    public boolean check(ValidationContext ctx, CSGObject csgobject) {
                        return new DuplicatedElementValidationFunction("csgSetOperator").check(ctx, (TreeNodeWithChangeSupport)csgobject) && new DuplicatedElementValidationFunction("csgPrimitive").check(ctx, (TreeNodeWithChangeSupport)csgobject) && new DuplicatedElementValidationFunction("csgTranslation").check(ctx, (TreeNodeWithChangeSupport)csgobject) && new DuplicatedElementValidationFunction("csgRotation").check(ctx, (TreeNodeWithChangeSupport)csgobject) && new DuplicatedElementValidationFunction("csgScale").check(ctx, (TreeNodeWithChangeSupport)csgobject) && new DuplicatedElementValidationFunction("csgHomogeneousTransformation").check(ctx, (TreeNodeWithChangeSupport)csgobject) && new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)csgobject);
                    }
                };
                break;
            }
            case 1222305: {
                func = new ValidationFunction<CSGObject>(){

                    public boolean check(ValidationContext ctx, CSGObject csgobject) {
                        Geometry g;
                        SpatialModelPlugin smp;
                        return !csgobject.isSetDomainType() || !(smp = (SpatialModelPlugin)csgobject.getModel().getPlugin("spatial")).isSetGeometry() || (g = smp.getGeometry()).getDomainType(csgobject.getDomainType()) != null;
                    }
                };
                break;
            }
            case 1222306: {
                break;
            }
            case 1222307: {
                func = new InvalidAttributeValidationFunction("ordinal");
            }
        }
        return func;
    }
}

