/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ext.spatial.CompartmentMapping;
import org.sbml.jsbml.ext.spatial.DomainType;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class CompartmentMappingConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221301, 1221306);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221301: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221302: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221303: {
                func = new UnknownPackageAttributeValidationFunction<CompartmentMapping>("spatial"){

                    public boolean check(ValidationContext ctx, CompartmentMapping cm) {
                        if (!cm.isSetId()) {
                            return false;
                        }
                        if (!cm.isSetDomainType()) {
                            return false;
                        }
                        if (!cm.isSetUnitSize()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)cm);
                    }
                };
                break;
            }
            case 1221304: {
                func = new ValidationFunction<CompartmentMapping>(){

                    public boolean check(ValidationContext ctx, CompartmentMapping cm) {
                        Geometry g;
                        DomainType dt;
                        Model m;
                        SpatialModelPlugin smp;
                        return !cm.isSetDomainType() || !(smp = (SpatialModelPlugin)(m = cm.getModel()).getPlugin("spatial")).isSetGeometry() || (dt = (g = smp.getGeometry()).getDomainType(cm.getDomainType())) != null;
                    }
                };
                break;
            }
            case 1221305: {
                func = new InvalidAttributeValidationFunction("unitSize");
                break;
            }
            case 1221306: {
                func = new ValidationFunction<CompartmentMapping>(){

                    public boolean check(ValidationContext ctx, CompartmentMapping cm) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

