/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.CoordinateComponent;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class CoordinateComponentConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221401, 1221407);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221401: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221402: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221403: {
                func = new UnknownPackageAttributeValidationFunction<CoordinateComponent>("spatial"){

                    public boolean check(ValidationContext ctx, CoordinateComponent cc) {
                        if (!cc.isSetId()) {
                            return false;
                        }
                        if (!cc.isSetType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)cc);
                    }
                };
                break;
            }
            case 1221404: {
                func = new ValidationFunction<CoordinateComponent>(){

                    public boolean check(ValidationContext ctx, CoordinateComponent cc) {
                        boolean boundary_min = cc.isSetBoundaryMinimum() && new DuplicatedElementValidationFunction("boundaryMin").check(ctx, (TreeNodeWithChangeSupport)cc);
                        boolean boundary_max = cc.isSetBoundaryMaximum() && new DuplicatedElementValidationFunction("boundaryMax").check(ctx, (TreeNodeWithChangeSupport)cc);
                        boolean noOtherElement = new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)cc);
                        return boundary_min && boundary_max && noOtherElement;
                    }
                };
                break;
            }
            case 1221405: {
                func = new InvalidAttributeValidationFunction("type");
                break;
            }
            case 1221406: {
                func = new ValidationFunction<CoordinateComponent>(){

                    public boolean check(ValidationContext ctx, CoordinateComponent cc) {
                        return true;
                    }
                };
                break;
            }
            case 1221407: {
                func = new ValidationFunction<CoordinateComponent>(){

                    public boolean check(ValidationContext ctx, CoordinateComponent cc) {
                        if (cc.isSetUnits()) {
                            return cc.getModel().getUnitDefinition(cc.getUnits()) != null;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

