/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import java.util.StringTokenizer;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.ParametricObject;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class ParametricObjectConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1222101, 1222110);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1222101: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1222102: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1222103: {
                func = new UnknownPackageAttributeValidationFunction<ParametricObject>("spatial"){

                    public boolean check(ValidationContext ctx, ParametricObject po) {
                        if (!po.isSetId()) {
                            return false;
                        }
                        if (!po.isSetPolygonType()) {
                            return false;
                        }
                        if (!po.isSetDomainType()) {
                            return false;
                        }
                        if (!po.isSetPointIndex()) {
                            return false;
                        }
                        if (!po.isSetPointIndexLength()) {
                            return false;
                        }
                        if (!po.isSetCompression()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)po);
                    }
                };
                break;
            }
            case 1222104: {
                func = new InvalidAttributeValidationFunction("polygonType");
                break;
            }
            case 1222105: {
                func = new ValidationFunction<ParametricObject>(){

                    public boolean check(ValidationContext ctx, ParametricObject po) {
                        SpatialModelPlugin smp;
                        if (po.isSetDomainType() && (smp = (SpatialModelPlugin)po.getModel().getPlugin("spatial")).isSetGeometry()) {
                            Geometry g = smp.getGeometry();
                            return g.getDomainType(po.getDomainType()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1222106: {
                func = new ValidationFunction<ParametricObject>(){

                    public boolean check(ValidationContext ctx, ParametricObject po) {
                        if (po.isSetPointIndex()) {
                            String pointIndex = po.getPointIndex().trim();
                            StringTokenizer test = new StringTokenizer(pointIndex, " ;");
                            while (test.hasMoreTokens()) {
                                try {
                                    StringTools.parseSBMLInt((String)test.nextToken());
                                }
                                catch (Exception e) {
                                    return false;
                                }
                            }
                            return true;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1222107: {
                func = new InvalidAttributeValidationFunction("pointIndexLength");
                break;
            }
            case 1222108: {
                func = new InvalidAttributeValidationFunction("compression");
                break;
            }
            case 1222109: {
                func = new ValidationFunction<ParametricObject>(){

                    public boolean check(ValidationContext ctx, ParametricObject po) {
                        return true;
                    }
                };
                break;
            }
            case 1222110: {
                func = new InvalidAttributeValidationFunction("dataType");
            }
        }
        return func;
    }
}

