/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import java.util.StringTokenizer;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SampledField;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SampledFieldConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221601, 1221612);
                this.addRangeToSet(set, 1221650, 1221652);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221601: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221603: {
                func = new UnknownPackageAttributeValidationFunction<SampledField>("spatial"){

                    public boolean check(ValidationContext ctx, SampledField sf) {
                        if (!sf.isSetId()) {
                            return false;
                        }
                        if (!sf.isSetDataType()) {
                            return false;
                        }
                        if (!sf.isSetNumSamples1()) {
                            return false;
                        }
                        if (!sf.isSetInterpolationType()) {
                            return false;
                        }
                        if (!sf.isSetCompression()) {
                            return false;
                        }
                        if (!sf.isSetSamples()) {
                            return false;
                        }
                        if (!sf.isSetSamplesLength()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)sf);
                    }
                };
                break;
            }
            case 1221604: {
                func = new InvalidAttributeValidationFunction("dataType");
                break;
            }
            case 1221605: {
                func = new InvalidAttributeValidationFunction("numSamples1");
                break;
            }
            case 1221606: {
                func = new InvalidAttributeValidationFunction("interpolationType");
                break;
            }
            case 1221607: {
                func = new InvalidAttributeValidationFunction("compression");
                break;
            }
            case 1221608: {
                func = new ValidationFunction<SampledField>(){

                    public boolean check(ValidationContext ctx, SampledField sf) {
                        if (sf.isSetSamples()) {
                            String samples = sf.getSamples().trim();
                            StringTokenizer test = new StringTokenizer(samples);
                            while (test.hasMoreTokens()) {
                                try {
                                    StringTools.parseSBMLInt((String)test.nextToken());
                                }
                                catch (Exception e) {
                                    return false;
                                }
                            }
                            return true;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1221609: {
                func = new InvalidAttributeValidationFunction("samplesLength");
                break;
            }
            case 1221610: {
                func = new ValidationFunction<SampledField>(){

                    public boolean check(ValidationContext ctx, SampledField sf) {
                        return true;
                    }
                };
                break;
            }
            case 1221611: {
                func = new InvalidAttributeValidationFunction("numSamples2");
                break;
            }
            case 1221612: {
                func = new InvalidAttributeValidationFunction("numSamples3");
                break;
            }
            case 1221650: {
                func = new ValidationFunction<SampledField>(){

                    public boolean check(ValidationContext ctx, SampledField sf) {
                        Geometry g;
                        SpatialModelPlugin smp = (SpatialModelPlugin)sf.getModel().getPlugin("spatial");
                        return !smp.isSetGeometry() || (g = smp.getGeometry()).getCoordinateComponentCount() != 1 || sf.isSetNumSamples1() && !sf.isSetNumSamples2() && !sf.isSetNumSamples3();
                    }
                };
                break;
            }
            case 1221651: {
                func = new ValidationFunction<SampledField>(){

                    public boolean check(ValidationContext ctx, SampledField sf) {
                        Geometry g;
                        SpatialModelPlugin smp = (SpatialModelPlugin)sf.getModel().getPlugin("spatial");
                        return !smp.isSetGeometry() || (g = smp.getGeometry()).getCoordinateComponentCount() != 2 || sf.isSetNumSamples1() && sf.isSetNumSamples2() && !sf.isSetNumSamples3();
                    }
                };
                break;
            }
            case 1221652: {
                func = new ValidationFunction<SampledField>(){

                    public boolean check(ValidationContext ctx, SampledField sf) {
                        Geometry g;
                        SpatialModelPlugin smp = (SpatialModelPlugin)sf.getModel().getPlugin("spatial");
                        return !smp.isSetGeometry() || (g = smp.getGeometry()).getCoordinateComponentCount() != 3 || sf.isSetNumSamples1() && sf.isSetNumSamples2() && sf.isSetNumSamples3();
                    }
                };
            }
        }
        return func;
    }
}

