/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.SpatialCompartmentPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class SpatialCompartmentPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                set.add(1220301);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        ValidationFunction<SpatialCompartmentPlugin> func = null;
        switch (errorCode) {
            case 1220301: {
                func = new ValidationFunction<SpatialCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, SpatialCompartmentPlugin spatialCP) {
                        boolean onlyOneCM = new DuplicatedElementValidationFunction("compartmentMapping").check(ctx, (TreeNodeWithChangeSupport)spatialCP);
                        boolean noOtherElements = new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)spatialCP);
                        return onlyOneCM && noOtherElements;
                    }
                };
            }
        }
        return func;
    }
}

