/*
 * Decompiled with CFR 0.152.
 */
package yalantis.com.sidemenu.util;

import android.os.Handler;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.List;
import yalantis.com.sidemenu.R;
import yalantis.com.sidemenu.animation.FlipAnimation;
import yalantis.com.sidemenu.interfaces.Resourceble;
import yalantis.com.sidemenu.interfaces.ScreenShotable;

public class ViewAnimator<T extends Resourceble> {
    private final int ANIMATION_DURATION = 175;
    public static final int CIRCULAR_REVEAL_ANIMATION_DURATION = 500;
    private AppCompatActivity appCompatActivity;
    private List<T> list;
    private List<View> viewList = new ArrayList<View>();
    private ScreenShotable screenShotable;
    private DrawerLayout drawerLayout;
    private ViewAnimatorListener animatorListener;

    public ViewAnimator(AppCompatActivity activity, List<T> items, ScreenShotable screenShotable, DrawerLayout drawerLayout, ViewAnimatorListener animatorListener) {
        this.appCompatActivity = activity;
        this.list = items;
        this.screenShotable = screenShotable;
        this.drawerLayout = drawerLayout;
        this.animatorListener = animatorListener;
    }

    public void showMenuContent() {
        this.setViewsClickable(false);
        this.viewList.clear();
        double size = this.list.size();
        int i = 0;
        while ((double)i < size) {
            View viewMenu = this.appCompatActivity.getLayoutInflater().inflate(R.layout.menu_list_item, null);
            final int finalI = i;
            viewMenu.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int[] location = new int[]{0, 0};
                    v.getLocationOnScreen(location);
                    ViewAnimator.this.switchItem((Resourceble)ViewAnimator.this.list.get(finalI), location[1] + v.getHeight() / 2);
                }
            });
            ((ImageView)viewMenu.findViewById(R.id.menu_item_image)).setImageResource(((Resourceble)this.list.get(i)).getImageRes());
            viewMenu.setVisibility(8);
            viewMenu.setEnabled(false);
            this.viewList.add(viewMenu);
            this.animatorListener.addViewToContainer(viewMenu);
            final double position = i;
            double delay = 525.0 * (position / size);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (position < (double)ViewAnimator.this.viewList.size()) {
                        ViewAnimator.this.animateView((int)position);
                    }
                    if (position == (double)(ViewAnimator.this.viewList.size() - 1)) {
                        ViewAnimator.this.screenShotable.takeScreenShot();
                        ViewAnimator.this.setViewsClickable(true);
                    }
                }
            }, (long)delay);
            ++i;
        }
    }

    private void hideMenuContent() {
        this.setViewsClickable(false);
        double size = this.list.size();
        for (int i = this.list.size(); i >= 0; --i) {
            final double position = i;
            double delay = 525.0 * (position / size);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (position < (double)ViewAnimator.this.viewList.size()) {
                        ViewAnimator.this.animateHideView((int)position);
                    }
                }
            }, (long)delay);
        }
    }

    private void setViewsClickable(boolean clickable) {
        this.animatorListener.disableHomeButton();
        for (View view : this.viewList) {
            view.setEnabled(clickable);
        }
    }

    private void animateView(int position) {
        final View view = this.viewList.get(position);
        view.setVisibility(0);
        FlipAnimation rotation = new FlipAnimation(90.0f, 0.0f, 0.0f, (float)view.getHeight() / 2.0f);
        rotation.setDuration(175L);
        rotation.setFillAfter(true);
        rotation.setInterpolator((Interpolator)new AccelerateInterpolator());
        rotation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.clearAnimation();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        view.startAnimation((Animation)rotation);
    }

    private void animateHideView(final int position) {
        final View view = this.viewList.get(position);
        FlipAnimation rotation = new FlipAnimation(0.0f, 90.0f, 0.0f, (float)view.getHeight() / 2.0f);
        rotation.setDuration(175L);
        rotation.setFillAfter(true);
        rotation.setInterpolator((Interpolator)new AccelerateInterpolator());
        rotation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.clearAnimation();
                view.setVisibility(4);
                if (position == ViewAnimator.this.viewList.size() - 1) {
                    ViewAnimator.this.animatorListener.enableHomeButton();
                    ViewAnimator.this.drawerLayout.closeDrawers();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        view.startAnimation((Animation)rotation);
    }

    private void switchItem(Resourceble slideMenuItem, int topPosition) {
        this.screenShotable = this.animatorListener.onSwitch(slideMenuItem, this.screenShotable, topPosition);
        this.hideMenuContent();
    }

    public static interface ViewAnimatorListener {
        public ScreenShotable onSwitch(Resourceble var1, ScreenShotable var2, int var3);

        public void disableHomeButton();

        public void enableHomeButton();

        public void addViewToContainer(View var1);
    }
}

