/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.images;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleImages;
import qupath.lib.analysis.images.SimpleModifiableImage;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.interfaces.ROI;

public class ContourTracing {
    private static final Logger logger = LoggerFactory.getLogger(ContourTracing.class);

    public static List<PathObject> labelsToDetections(Collection<Path> paths, boolean mergeByLabel) throws IOException {
        List<PathObject> list = paths.parallelStream().flatMap(p -> ContourTracing.labelsToDetectionsStream(p)).toList();
        if (mergeByLabel) {
            return ContourTracing.mergeByName(list);
        }
        return list;
    }

    public static List<PathObject> labelsToCells(Collection<Path> paths, boolean mergeByLabel) throws IOException {
        List<PathObject> list = paths.parallelStream().flatMap(p -> ContourTracing.labelsToCellsStream(p)).toList();
        if (mergeByLabel) {
            return ContourTracing.mergeByName(list);
        }
        return list;
    }

    private static <K> List<PathObject> mergeByName(Collection<? extends PathObject> pathObjects) {
        return PathObjectTools.mergeObjects(pathObjects, p -> p.getName());
    }

    private static Stream<PathObject> labelsToDetectionsStream(Path path) {
        try {
            return ContourTracing.labelsToDetections(path, null).stream();
        }
        catch (IOException e) {
            logger.error("Error parsing detections from " + String.valueOf(path) + ": " + e.getLocalizedMessage(), (Throwable)e);
            return Stream.empty();
        }
    }

    private static Stream<PathObject> labelsToCellsStream(Path path) {
        try {
            return ContourTracing.labelsToCells(path, null).stream();
        }
        catch (IOException e) {
            logger.error("Error parsing cells from " + String.valueOf(path) + ": " + e.getLocalizedMessage(), (Throwable)e);
            return Stream.empty();
        }
    }

    public static List<PathObject> labelsToDetections(Path path, RegionRequest request) throws IOException {
        RequestImage requestImage = ContourTracing.readImage(path, request);
        SimpleImage image = ContourTracing.extractBand(requestImage.getImage().getRaster(), 0);
        return ContourTracing.createDetections(image, requestImage.getRequest(), 1, -1);
    }

    public static List<PathObject> labelsToCells(Path path, RegionRequest request) throws IOException {
        RequestImage requestImage = ContourTracing.readImage(path, request);
        BufferedImage img = requestImage.getImage();
        if (img.getRaster().getNumBands() < 2) {
            throw new IllegalArgumentException("labelsToCells requires an image with at least 2 channels, cannot convert " + String.valueOf(path));
        }
        SimpleImage imageNuclei = ContourTracing.extractBand(img.getRaster(), 0);
        SimpleImage imageCells = ContourTracing.extractBand(img.getRaster(), 1);
        return ContourTracing.createCells(imageNuclei, imageCells, requestImage.getRequest(), 1, -1);
    }

    public static List<PathObject> labelsToAnnotations(Collection<Path> paths, boolean mergeByLabel) throws IOException {
        List<PathObject> list = paths.parallelStream().flatMap(p -> ContourTracing.labelsToAnnotationsStream(p)).toList();
        if (mergeByLabel) {
            return ContourTracing.mergeByName(list);
        }
        return list;
    }

    private static Stream<PathObject> labelsToAnnotationsStream(Path path) {
        try {
            return ContourTracing.labelsToAnnotations(path, null).stream();
        }
        catch (IOException e) {
            logger.error("Error parsing annotations from " + String.valueOf(path) + ": " + e.getLocalizedMessage(), (Throwable)e);
            return Stream.empty();
        }
    }

    public static List<PathObject> labelsToAnnotations(Path path, RegionRequest request) throws IOException {
        RequestImage requestImage = ContourTracing.readImage(path, request);
        SimpleImage image = ContourTracing.extractBand(requestImage.getImage().getRaster(), 0);
        return ContourTracing.createAnnotations(image, requestImage.getRequest(), 1, -1);
    }

    public static List<PathObject> labelsToObjects(Path path, RegionRequest request, BiFunction<ROI, Number, PathObject> creator) throws IOException {
        RequestImage requestImage = ContourTracing.readImage(path, request);
        SimpleImage image = ContourTracing.extractBand(requestImage.getImage().getRaster(), 0);
        return ContourTracing.createObjects(image, request, 1, -1, creator);
    }

    private static RequestImage readImage(Path path, RegionRequest request) throws IOException {
        BufferedImage img = ImageIO.read(path.toFile());
        if (request == null) {
            String name = path.getFileName().toString();
            request = ContourTracing.parseRegion(name, img.getWidth(), img.getHeight());
        }
        if (img == null) {
            ImageServer<BufferedImage> server = ImageServers.buildServer(path.toUri(), new String[0]);
            img = server.readRegion(request);
        }
        return new RequestImage(request, img);
    }

    public static RegionRequest parseRegion(String name, int width, int height) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int z = 0;
        int t = 0;
        double downsample = Double.NaN;
        String patternString = "\\[([a-zA-Z]=[\\d\\.]+,?)*\\]";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String[] parts;
            String group = matcher.group();
            block18: for (String part : parts = group.substring(1, group.length() - 1).split(",")) {
                String[] split = part.split("=");
                switch (split[0]) {
                    case "x": {
                        x = Integer.parseInt(split[1]);
                        continue block18;
                    }
                    case "y": {
                        y = Integer.parseInt(split[1]);
                        continue block18;
                    }
                    case "w": {
                        w = Integer.parseInt(split[1]);
                        continue block18;
                    }
                    case "h": {
                        h = Integer.parseInt(split[1]);
                        continue block18;
                    }
                    case "z": {
                        z = Integer.parseInt(split[1]);
                        continue block18;
                    }
                    case "t": {
                        t = Integer.parseInt(split[1]);
                        continue block18;
                    }
                    case "d": {
                        downsample = Double.parseDouble(split[1]);
                        continue block18;
                    }
                    default: {
                        logger.warn("Unknown region component '{}'", (Object)part);
                    }
                }
            }
        } else {
            return null;
        }
        if (!Double.isFinite(downsample)) {
            if (w > 0 && h > 0 && width > 0 && height > 0) {
                double downsampleX = (double)w / (double)width;
                double downsampleY = (double)h / (double)height;
                downsample = (downsampleX + downsampleY) / 2.0;
                if (!GeneralTools.almostTheSame(downsampleX, downsampleY, 0.01)) {
                    logger.warn("Estimated downsample x={} and y={}, will use average {}", new Object[]{downsampleX, downsampleY, downsample});
                } else if (downsampleX != downsampleY) {
                    logger.debug("Estimated downsample x={} and y={}, will use average {}", new Object[]{downsampleX, downsampleY, downsample});
                }
            } else {
                logger.debug("Using default downsample of 1");
                downsample = 1.0;
            }
        }
        return RegionRequest.createInstance(name, downsample, x, y, w, h, z, t);
    }

    public static List<PathObject> createObjects(Raster raster, int band, RegionRequest region, int minLabel, int maxLabel, BiFunction<ROI, Number, PathObject> creator) {
        SimpleImage image = ContourTracing.extractBand(raster, band);
        return ContourTracing.createObjects(image, region, minLabel, maxLabel, creator);
    }

    public static List<PathObject> createObjects(SimpleImage image, RegionRequest region, int minLabel, int maxLabel, BiFunction<ROI, Number, PathObject> creator) {
        Map<Number, ROI> rois = ContourTracing.createROIs(image, region, minLabel, maxLabel);
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        for (Map.Entry<Number, ROI> entry : rois.entrySet()) {
            PathObject pathObject = creator.apply(entry.getValue(), entry.getKey());
            pathObjects.add(pathObject);
        }
        return pathObjects;
    }

    public static List<PathObject> createDetections(SimpleImage image, RegionRequest region, int minLabel, int maxLabel) {
        return ContourTracing.createObjects(image, region, minLabel, maxLabel, ContourTracing.createNumberedObjectFunction(r -> PathObjects.createDetectionObject(r)));
    }

    public static List<PathObject> createAnnotations(SimpleImage image, RegionRequest region, int minLabel, int maxLabel) {
        return ContourTracing.createObjects(image, region, minLabel, maxLabel, ContourTracing.createNumberedObjectFunction(r -> PathObjects.createAnnotationObject(r)));
    }

    private static String numberToString(Number n) {
        if (n == null) {
            return null;
        }
        double value = n.doubleValue();
        if (value == Math.rint(value)) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    public static BiFunction<ROI, Number, PathObject> createNumberedObjectFunction(Function<ROI, PathObject> creator) {
        return ContourTracing.createObjectFunction(creator, (p, n) -> p.setName(ContourTracing.numberToString(n)));
    }

    public static BiFunction<ROI, Number, PathObject> createObjectFunction(Function<ROI, PathObject> creator, BiConsumer<PathObject, Number> numberer) {
        return (r, n) -> {
            PathObject pathObject = (PathObject)creator.apply((ROI)r);
            if (numberer != null && n != null) {
                numberer.accept(pathObject, (Number)n);
            }
            return pathObject;
        };
    }

    public static List<PathObject> createCells(Raster raster, int bandNuclei, int bandCells, RegionRequest region, int minLabel, int maxLabel) {
        SimpleImage imageNuclei = ContourTracing.extractBand(raster, bandNuclei);
        SimpleImage imageCells = ContourTracing.extractBand(raster, bandCells);
        return ContourTracing.createCells(imageNuclei, imageCells, region, minLabel, maxLabel);
    }

    public static List<PathObject> createCells(SimpleImage imageNuclei, SimpleImage imageCells, RegionRequest region, int minLabel, int maxLabel) {
        if (imageNuclei != imageCells) {
            if (imageNuclei.getWidth() != imageCells.getWidth() || imageNuclei.getHeight() != imageCells.getHeight()) {
                throw new IllegalArgumentException(String.format("Labelled images for nuclei and cells don't match! Image dimensions are different (%d x %d, %d x %d).", imageNuclei.getWidth(), imageNuclei.getHeight(), imageCells.getWidth(), imageCells.getHeight()));
            }
            if (!ContourTracing.maybeCellLabels(imageNuclei, imageCells, minLabel)) {
                throw new IllegalArgumentException("Nucleus and cell labelled images don't match! All labels >= " + minLabel + " in imageNuclei must be the same as labels in imageCells.");
            }
        }
        Map<Number, ROI> nucleusROIs = ContourTracing.createROIs(imageNuclei, region, minLabel, maxLabel);
        Map<Number, ROI> cellROIs = ContourTracing.createROIs(imageCells, region, minLabel, maxLabel);
        ArrayList<PathObject> cells = new ArrayList<PathObject>();
        for (Map.Entry<Number, ROI> entry : cellROIs.entrySet()) {
            ROI roiCell = entry.getValue();
            ROI roiNucleus = nucleusROIs.getOrDefault(entry.getKey(), null);
            PathObject cell = PathObjects.createCellObject(roiCell, roiNucleus, null, null);
            cell.setName(ContourTracing.numberToString(entry.getKey()));
            cells.add(cell);
        }
        return cells;
    }

    public static boolean maybeCellLabels(Raster raster, int bandNuclei, int bandCells, int minLabel) {
        if (bandNuclei == bandCells) {
            return true;
        }
        SimpleImage imageNuclei = ContourTracing.extractBand(raster, bandNuclei);
        SimpleImage imageCells = ContourTracing.extractBand(raster, bandCells);
        return ContourTracing.maybeCellLabels(imageNuclei, imageCells, minLabel);
    }

    public static boolean maybeCellLabels(SimpleImage imageNuclei, SimpleImage imageCells, int minLabel) {
        if (imageNuclei.getWidth() != imageCells.getWidth() || imageNuclei.getHeight() != imageCells.getHeight()) {
            return false;
        }
        for (int y = 0; y < imageNuclei.getHeight(); ++y) {
            for (int x = 0; x < imageNuclei.getWidth(); ++x) {
                float val = imageNuclei.getValue(x, y);
                if (!(val >= (float)minLabel) || val == imageCells.getValue(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public static SimpleImage extractBand(Raster raster, int band) {
        float[] pixels = raster.getSamples(0, 0, raster.getWidth(), raster.getHeight(), band, (float[])null);
        return SimpleImages.createFloatImage(pixels, raster.getWidth(), raster.getHeight());
    }

    public static Map<Number, ROI> createROIs(Raster raster, int band, RegionRequest region, int minLabel, int maxLabel) {
        SimpleImage image = ContourTracing.extractBand(raster, band);
        return ContourTracing.createROIs(image, region, minLabel, maxLabel);
    }

    public static Map<Number, Geometry> createGeometries(SimpleImage image, RegionRequest region, int minLabel, int maxLabel) {
        HashMap<Number, Envelope> envelopes = new HashMap<Number, Envelope>();
        if (minLabel == maxLabel) {
            envelopes.put(minLabel, null);
        } else {
            boolean searchingMaxLabel = maxLabel < minLabel;
            int maxLabelFound = Integer.MIN_VALUE;
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int label;
                    float val = Math.round(image.getValue(x, y));
                    if (val != (float)(label = Math.round(val))) continue;
                    if (label > maxLabel) {
                        maxLabelFound = label;
                        if (searchingMaxLabel) {
                            maxLabel = maxLabelFound;
                        }
                    }
                    if (!ContourTracing.selected(label, minLabel, maxLabel)) continue;
                    envelopes.computeIfAbsent(label, k -> new Envelope()).expandToInclude((double)x, (double)y);
                }
            }
            if (maxLabelFound < minLabel) {
                return Collections.emptyMap();
            }
        }
        Map<Number, Geometry> map = envelopes.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, e -> ContourTracing.createTracedGeometry(image, ((Number)e.getKey()).doubleValue(), ((Number)e.getKey()).doubleValue(), region, (Envelope)e.getValue())));
        TreeMap<Number, Geometry> rois = new TreeMap<Number, Geometry>();
        for (Map.Entry<Number, Geometry> entry : map.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            rois.put(entry.getKey(), entry.getValue());
        }
        return rois;
    }

    public static Map<Number, ROI> createROIs(SimpleImage image, RegionRequest region, int minLabel, int maxLabel) {
        Map<Number, Geometry> map = ContourTracing.createGeometries(image, region, minLabel, maxLabel);
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, es -> {
            Geometry geom = (Geometry)es.getValue();
            return geom == null ? null : GeometryTools.geometryToROI(geom, region == null ? ImagePlane.getDefaultPlane() : region.getImagePlane());
        }));
    }

    private static ROI labelToROI(SimpleImage image, double label, RegionRequest region, Envelope envelope) {
        return ContourTracing.createTracedROI(image, label, label, region, envelope);
    }

    public static ROI createTracedROI(Raster raster, double minThresholdInclusive, double maxThresholdInclusive, int band, RegionRequest request) {
        Geometry geom = ContourTracing.createTracedGeometry(raster, minThresholdInclusive, maxThresholdInclusive, band, request);
        return GeometryTools.geometryToROI(geom, request == null ? ImagePlane.getDefaultPlane() : request.getImagePlane());
    }

    public static ROI createTracedROI(SimpleImage image, double minThresholdInclusive, double maxThresholdInclusive, RegionRequest request) {
        return ContourTracing.createTracedROI(image, minThresholdInclusive, maxThresholdInclusive, request, null);
    }

    private static ROI createTracedROI(SimpleImage image, double minThresholdInclusive, double maxThresholdInclusive, RegionRequest request, Envelope envelope) {
        Geometry geom = ContourTracing.createTracedGeometry(image, minThresholdInclusive, maxThresholdInclusive, request, envelope);
        return geom == null ? null : GeometryTools.geometryToROI(geom, request == null ? ImagePlane.getDefaultPlane() : request.getImagePlane());
    }

    private static Geometry createTracedGeometry(Raster raster, double minThresholdInclusive, double maxThresholdInclusive, int band, TileRequest request, Envelope envelope) {
        SimpleImage image = ContourTracing.extractBand(raster, band);
        return ContourTracing.createTracedGeometry(image, minThresholdInclusive, maxThresholdInclusive, request, envelope);
    }

    private static Geometry createTracedGeometry(SimpleImage image, double minThresholdInclusive, double maxThresholdInclusive, TileRequest tile, Envelope envelope) {
        double xOffset = 0.0;
        double yOffset = 0.0;
        if (tile != null && tile.getDownsample() == 1.0) {
            xOffset = (double)tile.getTileX() * tile.getDownsample();
            yOffset = (double)tile.getTileY() * tile.getDownsample();
        }
        Geometry geom = ContourTracing.traceGeometry(image, minThresholdInclusive, maxThresholdInclusive, xOffset, yOffset, envelope);
        if (tile != null && tile.getDownsample() != 1.0 && geom != null) {
            double scale = tile.getDownsample();
            AffineTransformation transform = AffineTransformation.scaleInstance((double)scale, (double)scale);
            if (!(transform = transform.translate((double)tile.getTileX() * tile.getDownsample(), (double)tile.getTileY() * tile.getDownsample())).isIdentity()) {
                geom = transform.transform(geom);
            }
        }
        return geom;
    }

    public static Geometry createTracedGeometry(SimpleImage image, double minThresholdInclusive, double maxThresholdInclusive, RegionRequest request) {
        return ContourTracing.createTracedGeometry(image, minThresholdInclusive, maxThresholdInclusive, request, null);
    }

    private static Geometry createTracedGeometry(SimpleImage image, double minThresholdInclusive, double maxThresholdInclusive, RegionRequest request, Envelope envelope) {
        double xOffset = 0.0;
        double yOffset = 0.0;
        if (request != null && request.getDownsample() == 1.0) {
            xOffset = request.getX();
            yOffset = request.getY();
        }
        Geometry geom = ContourTracing.traceGeometry(image, minThresholdInclusive, maxThresholdInclusive, xOffset, yOffset, envelope);
        if (request != null && request.getDownsample() != 1.0 && geom != null) {
            double scale = request.getDownsample();
            AffineTransformation transform = AffineTransformation.scaleInstance((double)scale, (double)scale);
            if (!(transform = transform.translate((double)request.getX(), (double)request.getY())).isIdentity()) {
                geom = transform.transform(geom);
            }
        }
        return geom;
    }

    public static Geometry createTracedGeometry(Raster raster, double minThresholdInclusive, double maxThresholdInclusive, int band, RegionRequest request) {
        SimpleImage image = ContourTracing.extractBand(raster, band);
        return ContourTracing.createTracedGeometry(image, minThresholdInclusive, maxThresholdInclusive, request);
    }

    public static Geometry traceGeometry(ImageServer<BufferedImage> server, RegionRequest regionRequest, Geometry clipArea, int channel, double minThreshold, double maxThreshold) throws IOException {
        Map<Integer, Geometry> map = ContourTracing.traceGeometries(server, regionRequest, clipArea, ChannelThreshold.create(channel, minThreshold, maxThreshold));
        if (map == null || map.isEmpty()) {
            return GeometryTools.getDefaultFactory().createPolygon();
        }
        assert (map.size() == 1);
        return map.values().iterator().next();
    }

    public static Map<Integer, Geometry> traceGeometries(ImageServer<BufferedImage> server, RegionRequest regionRequest, Geometry clipArea, ChannelThreshold ... thresholds) throws IOException {
        RegionRequest region = regionRequest;
        if (region == null) {
            if (clipArea == null) {
                region = RegionRequest.createInstance(server, server.getDownsampleForResolution(0));
            } else {
                env = clipArea.getEnvelopeInternal();
                region = RegionRequest.createInstance(server.getPath(), server.getDownsampleForResolution(0), GeometryTools.envelopToRegion(env, 0, 0));
            }
        } else if (clipArea != null) {
            env = clipArea.getEnvelopeInternal();
            region = region.intersect2D(GeometryTools.envelopToRegion(env, region.getZ(), region.getT()));
        }
        Collection<TileRequest> tiles = server.getTileRequestManager().getTileRequests(region);
        if (thresholds.length == 0 || tiles.isEmpty()) {
            return Collections.emptyMap();
        }
        double downsample = region.getDownsample();
        if (Math.abs(tiles.iterator().next().getDownsample() - downsample) > 0.001) {
            server = ImageServers.pyramidalize(server, downsample);
            tiles = server.getTileRequestManager().getTileRequests(region);
        }
        return ContourTracing.traceGeometriesImpl(server, tiles, clipArea, thresholds);
    }

    private static <T, S> List<S> invokeAll(ExecutorService pool, Collection<T> items, Function<T, S> fun) throws InterruptedException, ExecutionException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (T item : items) {
            futures.add(pool.submit(() -> fun.apply(item)));
        }
        ArrayList results = new ArrayList();
        for (Future future : futures) {
            results.add(future.get());
        }
        return results;
    }

    private static Map<Integer, Geometry> traceGeometriesImpl(ImageServer<BufferedImage> server, Collection<TileRequest> tiles, Geometry clipArea, ChannelThreshold ... thresholds) throws IOException {
        if (thresholds.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, Geometry> output = new LinkedHashMap<Integer, Geometry>();
        ExecutorService pool = Executors.newFixedThreadPool(ThreadTools.getParallelism());
        try {
            List<List> wrappers = ContourTracing.invokeAll(pool, tiles, t -> ContourTracing.traceGeometries(server, t, clipArea, thresholds));
            Map<Integer, List<GeometryWrapper>> geometryMap = wrappers.stream().flatMap(p -> p.stream()).collect(Collectors.groupingBy(g -> g.label));
            TreeSet<Integer> xBoundsSet = new TreeSet<Integer>();
            TreeSet<Integer> yBoundsSet = new TreeSet<Integer>();
            for (TileRequest t2 : tiles) {
                xBoundsSet.add(t2.getImageX());
                xBoundsSet.add(t2.getImageX() + t2.getImageWidth());
                yBoundsSet.add(t2.getImageY());
                yBoundsSet.add(t2.getImageY() + t2.getImageHeight());
            }
            int[] xBounds = xBoundsSet.stream().mapToInt(x -> x).toArray();
            int[] yBounds = yBoundsSet.stream().mapToInt(y -> y).toArray();
            LinkedHashMap<Integer, Future<Geometry>> futures = new LinkedHashMap<Integer, Future<Geometry>>();
            for (Map.Entry<Integer, List<GeometryWrapper>> entry : geometryMap.entrySet()) {
                List<GeometryWrapper> list = entry.getValue();
                if (list.isEmpty()) continue;
                futures.put(entry.getKey(), pool.submit(() -> ContourTracing.mergeGeometryWrappers(list, xBounds, yBounds)));
            }
            for (Map.Entry<Integer, List<GeometryWrapper>> entry : futures.entrySet()) {
                output.put(entry.getKey(), (Geometry)((Future)((Object)entry.getValue())).get());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            pool.shutdown();
        }
        return output;
    }

    private static Geometry mergeGeometryWrappers(List<GeometryWrapper> list, int[] xBounds, int[] yBounds) {
        Geometry geometry;
        if (list.isEmpty()) {
            return GeometryTools.getDefaultFactory().createEmpty(2);
        }
        if (list.size() == 1) {
            return list.get((int)0).geometry;
        }
        GeometryFactory factory = list.get((int)0).geometry.getFactory();
        ArrayList allPolygons = new ArrayList();
        for (GeometryWrapper temp : list) {
            PolygonExtracter.getPolygons((Geometry)temp.geometry, allPolygons);
        }
        boolean onlyBuffer = false;
        if (onlyBuffer) {
            Geometry singleGeometry = factory.buildGeometry(allPolygons);
            geometry = singleGeometry.buffer(0.0);
        } else {
            List items;
            Quadtree tree = new Quadtree();
            for (Polygon p : allPolygons) {
                tree.insert(p.getEnvelopeInternal(), (Object)p);
            }
            Envelope env = new Envelope();
            HashSet toMerge = new HashSet();
            for (int yi = 1; yi < yBounds.length - 1; ++yi) {
                env.init((double)(xBounds[0] - 1), (double)(xBounds[xBounds.length - 1] + 1), (double)(yBounds[yi] - 1), (double)(yBounds[yi] + 1));
                items = tree.query(env);
                if (items.size() <= 1) continue;
                toMerge.addAll(items);
            }
            for (int xi = 1; xi < xBounds.length - 1; ++xi) {
                env.init((double)(xBounds[xi] - 1), (double)(xBounds[xi] + 1), (double)(yBounds[0] - 1), (double)(yBounds[yBounds.length - 1] + 1));
                items = tree.query(env);
                if (items.size() <= 1) continue;
                toMerge.addAll(items);
            }
            if (!toMerge.isEmpty()) {
                logger.debug("Computing union for {}/{} polygons", (Object)toMerge.size(), (Object)allPolygons.size());
                Geometry mergedGeometry = GeometryTools.union(toMerge);
                Iterator iter = allPolygons.iterator();
                while (iter.hasNext()) {
                    if (!toMerge.contains(iter.next())) continue;
                    iter.remove();
                }
                allPolygons.removeAll(toMerge);
                ArrayList newPolygons = new ArrayList();
                PolygonExtracter.getPolygons((Geometry)mergedGeometry, newPolygons);
                allPolygons.addAll(newPolygons);
            }
            geometry = factory.buildGeometry(allPolygons);
            geometry.normalize();
        }
        return geometry;
    }

    private static List<GeometryWrapper> traceGeometries(ImageServer<BufferedImage> server, TileRequest tile, Geometry clipArea, ChannelThreshold ... thresholds) {
        try {
            return ContourTracing.traceGeometriesImpl(server, tile, clipArea, thresholds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<GeometryWrapper> traceGeometriesImpl(ImageServer<BufferedImage> server, TileRequest tile, Geometry clipArea, ChannelThreshold ... thresholds) throws IOException {
        boolean doClassification;
        if (thresholds.length == 0) {
            return Collections.emptyList();
        }
        RegionRequest request = tile.getRegionRequest();
        ArrayList<GeometryWrapper> list = new ArrayList<GeometryWrapper>();
        BufferedImage img = server.readRegion(request);
        ImageServerMetadata.ChannelType channelType = server.getMetadata().getChannelType();
        int h = img.getHeight();
        int w = img.getWidth();
        int nChannels = server.nChannels();
        boolean bl = doClassification = channelType == ImageServerMetadata.ChannelType.PROBABILITY && nChannels > 1 || channelType == ImageServerMetadata.ChannelType.CLASSIFICATION;
        if (doClassification) {
            SimpleModifiableImage image;
            if (channelType == ImageServerMetadata.ChannelType.PROBABILITY) {
                raster = img.getRaster();
                float[] output = new float[w * h];
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        int maxInd = 0;
                        float maxVal = raster.getSampleFloat(x, y, 0);
                        for (int c = 1; c < nChannels; ++c) {
                            float val = raster.getSampleFloat(x, y, c);
                            if (val > maxVal) {
                                maxInd = c;
                                maxVal = val;
                            }
                            output[y * w + x] = maxInd;
                        }
                    }
                }
                image = SimpleImages.createFloatImage(output, w, h);
            } else {
                raster = img.getRaster();
                float[] pixels = raster.getSamples(0, 0, w, h, 0, (float[])null);
                image = SimpleImages.createFloatImage(pixels, w, h);
            }
            for (ChannelThreshold threshold : thresholds) {
                int c = threshold.getChannel();
                Geometry geometry = ContourTracing.createTracedGeometry((SimpleImage)image, (double)c, (double)c, tile, null);
                if (geometry == null || geometry.isEmpty()) continue;
                if (clipArea != null) {
                    geometry = GeometryTools.attemptOperation(geometry, g -> g.intersection(clipArea));
                    geometry = GeometryTools.homogenizeGeometryCollection(geometry);
                }
                if (geometry.isEmpty() || !(geometry.getArea() > 0.0)) continue;
                list.add(new GeometryWrapper(geometry, c));
            }
        } else {
            WritableRaster raster = img.getRaster();
            HashMap<ChannelThreshold, Envelope> envelopes = new HashMap<ChannelThreshold, Envelope>();
            if (thresholds.length > -1) {
                logger.info("Populating envelopes!");
                ContourTracing.populateEnvelopes(raster, envelopes, thresholds);
            }
            for (ChannelThreshold threshold : thresholds) {
                Geometry geometry = ContourTracing.createTracedGeometry(raster, threshold.getMinThreshold(), threshold.getMaxThreshold(), threshold.getChannel(), tile, envelopes.getOrDefault(threshold, null));
                if (geometry == null) continue;
                if (clipArea != null) {
                    geometry = GeometryTools.attemptOperation(geometry, g -> g.intersection(clipArea));
                    geometry = GeometryTools.homogenizeGeometryCollection(geometry);
                }
                if (geometry.isEmpty() || !(geometry.getArea() > 0.0)) continue;
                list.add(new GeometryWrapper(geometry, threshold.getChannel()));
            }
        }
        return list;
    }

    private static void populateEnvelopes(WritableRaster raster, Map<ChannelThreshold, Envelope> envelopes, ChannelThreshold ... thresholds) {
        Map<Integer, List<ChannelThreshold>> groups = Arrays.stream(thresholds).collect(Collectors.groupingBy(ChannelThreshold::getChannel));
        for (Map.Entry<Integer, List<ChannelThreshold>> entry : groups.entrySet()) {
            int channel = entry.getKey();
            List<ChannelThreshold> channelThresholds = entry.getValue();
            SimpleImage image = ContourTracing.extractBand(raster, channel);
            ContourTracing.populateEnvelopes(image, envelopes, (ChannelThreshold[])channelThresholds.toArray(ChannelThreshold[]::new));
        }
    }

    private static void populateEnvelopes(SimpleImage image, Map<ChannelThreshold, Envelope> envelopes, ChannelThreshold ... thresholds) {
        int w = image.getWidth();
        int h = image.getHeight();
        for (ChannelThreshold t : thresholds) {
            envelopes.computeIfAbsent(t, k -> new Envelope());
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float val = image.getValue(x, y);
                for (ChannelThreshold t : thresholds) {
                    if (!ContourTracing.selected((double)val, t.getMinThreshold(), t.getMaxThreshold())) continue;
                    envelopes.get(t).expandToInclude((double)x, (double)y);
                }
            }
        }
    }

    private static boolean selected(int v, int min, int max) {
        return v >= min && v <= max;
    }

    private static boolean selected(float v, float min, float max) {
        return v >= min && v <= max;
    }

    private static boolean selected(double v, double min, double max) {
        return v >= min && v <= max;
    }

    private static Geometry traceGeometry(SimpleImage image, double min, double max, double xOffset, double yOffset, Envelope envelope) {
        GeometryFactory factory = GeometryTools.getDefaultFactory();
        PrecisionModel pm = factory.getPrecisionModel();
        int xStart = 0;
        int yStart = 0;
        int xEnd = image.getWidth();
        int yEnd = image.getHeight();
        if (envelope != null) {
            xStart = Math.max(xStart, (int)Math.floor(envelope.getMinX() - 1.0));
            yStart = Math.max(yStart, (int)Math.floor(envelope.getMinY() - 1.0));
            xEnd = Math.min(xEnd, (int)Math.ceil(envelope.getMaxX()) + 1);
            yEnd = Math.min(yEnd, (int)Math.ceil(envelope.getMaxY()) + 1);
        }
        ArrayList<LineString> lines = new ArrayList<LineString>();
        Coordinate lastHorizontalEdgeCoord = null;
        Coordinate[] lastVerticalEdgeCoords = new Coordinate[xEnd - xStart + 1];
        for (int y = yStart; y <= yEnd; ++y) {
            for (int x = xStart; x <= xEnd; ++x) {
                Coordinate nextEdgeCoord;
                boolean onVerticalEdge;
                boolean isOn = ContourTracing.inRange(image, x, y, min, max);
                boolean onHorizontalEdge = isOn != ContourTracing.inRange(image, x, y - 1, min, max);
                boolean bl = onVerticalEdge = isOn != ContourTracing.inRange(image, x - 1, y, min, max);
                if (onHorizontalEdge) {
                    nextEdgeCoord = ContourTracing.createCoordinate(pm, xOffset + (double)x, yOffset + (double)y);
                    if (lastHorizontalEdgeCoord != null) {
                        lines.add(factory.createLineString(ContourTracing.createCoordinateSequence(lastHorizontalEdgeCoord, nextEdgeCoord)));
                    }
                    lastHorizontalEdgeCoord = nextEdgeCoord;
                } else if (lastHorizontalEdgeCoord != null) {
                    nextEdgeCoord = ContourTracing.createCoordinate(pm, xOffset + (double)x, yOffset + (double)y);
                    lines.add(factory.createLineString(ContourTracing.createCoordinateSequence(lastHorizontalEdgeCoord, nextEdgeCoord)));
                    lastHorizontalEdgeCoord = null;
                }
                Coordinate lastVerticalEdgeCoord = lastVerticalEdgeCoords[x - xStart];
                if (onVerticalEdge) {
                    nextEdgeCoord = ContourTracing.createCoordinate(pm, xOffset + (double)x, yOffset + (double)y);
                    if (lastVerticalEdgeCoord != null) {
                        lines.add(factory.createLineString(ContourTracing.createCoordinateSequence(lastVerticalEdgeCoord, nextEdgeCoord)));
                    }
                    lastVerticalEdgeCoords[x - xStart] = nextEdgeCoord;
                    continue;
                }
                if (lastVerticalEdgeCoord == null) continue;
                nextEdgeCoord = ContourTracing.createCoordinate(pm, xOffset + (double)x, yOffset + (double)y);
                lines.add(factory.createLineString(ContourTracing.createCoordinateSequence(lastVerticalEdgeCoord, nextEdgeCoord)));
                lastVerticalEdgeCoords[x - xStart] = null;
            }
        }
        Polygonizer polygonizer = new Polygonizer(true);
        polygonizer.add(lines);
        Geometry originalPolygon = polygonizer.getGeometry();
        return originalPolygon;
    }

    private static Coordinate createCoordinate(PrecisionModel pm, double x, double y) {
        return new CoordinateXY(pm.makePrecise(x), pm.makePrecise(y));
    }

    private static CoordinateSequence createCoordinateSequence(Coordinate ... coords) {
        for (Coordinate c : coords) {
            GeometryTools.getDefaultFactory().getPrecisionModel().makePrecise(c);
        }
        return new CoordinateArraySequence(coords, 3, 0);
    }

    private static boolean inRange(SimpleImage image, int x, int y, double min, double max) {
        if (x < 0 || x >= image.getWidth() || y < 0 || y >= image.getHeight()) {
            return false;
        }
        double val = image.getValue(x, y);
        return val >= min && val <= max;
    }

    private static class RequestImage {
        private RegionRequest request;
        private BufferedImage img;

        public RequestImage(RegionRequest request, BufferedImage img) {
            this.request = request;
            this.img = img;
        }

        public RegionRequest getRequest() {
            return this.request;
        }

        public BufferedImage getImage() {
            return this.img;
        }
    }

    public static class ChannelThreshold {
        private final int channel;
        private final double minThreshold;
        private final double maxThreshold;

        private ChannelThreshold(int channel, double minThreshold, double maxThreshold) {
            this.channel = channel;
            this.minThreshold = minThreshold;
            this.maxThreshold = maxThreshold;
        }

        public static ChannelThreshold create(int channel) {
            return new ChannelThreshold(channel, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public static ChannelThreshold create(int channel, double minThreshold, double maxThreshold) {
            return new ChannelThreshold(channel, minThreshold, maxThreshold);
        }

        public static ChannelThreshold createAbove(int channel, double minThreshold) {
            return new ChannelThreshold(channel, minThreshold, Double.POSITIVE_INFINITY);
        }

        public static ChannelThreshold createBelow(int channel, double maxThreshold) {
            return new ChannelThreshold(channel, Double.NEGATIVE_INFINITY, maxThreshold);
        }

        public static ChannelThreshold createExactly(int channel, double threshold) {
            return new ChannelThreshold(channel, threshold, threshold);
        }

        public double getMinThreshold() {
            return this.minThreshold;
        }

        public double getMaxThreshold() {
            return this.maxThreshold;
        }

        public int getChannel() {
            return this.channel;
        }

        public String toString() {
            return String.format("Threshold %d (%s, %s)", this.channel, GeneralTools.formatNumber(this.minThreshold, 3), GeneralTools.formatNumber(this.maxThreshold, 3));
        }
    }

    private static class GeometryWrapper {
        final Geometry geometry;
        final int label;

        private GeometryWrapper(Geometry geometry, int label) {
            this.geometry = geometry;
            this.label = label;
        }
    }
}

