/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.stats;

public class ArrayWrappers {
    public static ArrayWrapper makeDoubleArrayWrapper(double[] array) {
        return new DoubleArrayWrapper(array);
    }

    public static ArrayWrapper makeFloatArrayWrapper(float[] array) {
        return new FloatArrayWrapper(array);
    }

    public static ArrayWrapper makeIntArrayWrapper(int[] array) {
        return new IntArrayWrapper(array);
    }

    public static ArrayWrapper makeUnsignedByteArrayWrapper(byte[] array) {
        return new UnsignedByteArrayWrapper(array);
    }

    public static ArrayWrapper makeUnsignedShortArrayWrapper(short[] array) {
        return new UnsignedShortArrayWrapper(array);
    }

    static class DoubleArrayWrapper
    implements ArrayWrapper {
        private final double[] array;

        public DoubleArrayWrapper(double[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind];
        }

        @Override
        public boolean isIntegerWrapper() {
            return false;
        }
    }

    static class FloatArrayWrapper
    implements ArrayWrapper {
        private final float[] array;

        public FloatArrayWrapper(float[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind];
        }

        @Override
        public boolean isIntegerWrapper() {
            return false;
        }
    }

    static class IntArrayWrapper
    implements ArrayWrapper {
        private final int[] array;

        public IntArrayWrapper(int[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind];
        }

        @Override
        public boolean isIntegerWrapper() {
            return true;
        }
    }

    static class UnsignedByteArrayWrapper
    implements ArrayWrapper {
        private final byte[] array;

        public UnsignedByteArrayWrapper(byte[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind] & 0xFF;
        }

        @Override
        public boolean isIntegerWrapper() {
            return true;
        }
    }

    static class UnsignedShortArrayWrapper
    implements ArrayWrapper {
        private final short[] array;

        public UnsignedShortArrayWrapper(short[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind] & 0xFFFF;
        }

        @Override
        public boolean isIntegerWrapper() {
            return true;
        }
    }

    public static interface ArrayWrapper {
        public int size();

        public double getDouble(int var1);

        public boolean isIntegerWrapper();
    }
}

