/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.awt.common;

import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.locationtech.jts.geom.util.AffineTransformation;
import qupath.lib.roi.GeometryTools;

public class AffineTransforms {
    public static AffineTransform from2D(double[][] mat) throws IllegalArgumentException {
        if (((double[][])mat).length == 3 && mat[2].length == 3 && Arrays.equals(mat[2], new double[]{0.0, 0.0, 1.0})) {
            mat = new double[][]{mat[0], mat[1]};
        }
        if (((double[][])mat).length == 2 && mat[0].length == 3 && mat[1].length == 3) {
            return new AffineTransform(mat[0][0], mat[1][0], mat[0][1], mat[1][1], mat[0][2], mat[1][2]);
        }
        throw new IllegalArgumentException("Transform matrix should have size double[2][3]");
    }

    public static AffineTransform fromRows(double ... mat) throws IllegalArgumentException {
        if (mat.length == 6) {
            return AffineTransforms.fromJTS(new AffineTransformation(mat));
        }
        throw new IllegalArgumentException("Flattened transform array should have length 6");
    }

    public static AffineTransform fromColumns(double ... mat) throws IllegalArgumentException {
        if (mat.length == 6) {
            return new AffineTransform(mat);
        }
        throw new IllegalArgumentException("Flattened transform array should have length 6");
    }

    public static AffineTransform fromScale(double scaleX, double scaleY) {
        return AffineTransform.getScaleInstance(scaleX, scaleY);
    }

    public static AffineTransform fromScale(double scale) {
        return AffineTransforms.fromScale(scale, scale);
    }

    public static AffineTransform identity() {
        return new AffineTransform();
    }

    public static AffineTransform fromJTS(AffineTransformation transform) {
        return GeometryTools.convertTransform(transform);
    }

    public static AffineTransformation toJTS(AffineTransform transform) {
        return GeometryTools.convertTransform(transform);
    }
}

