/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.classifiers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

@Deprecated
class ConfusionMatrix<T> {
    private List<T> classes = new ArrayList<T>();
    private int[][] matrix;
    private int errors = 0;
    private Function<T, String> stringFun;

    ConfusionMatrix(Collection<T> classes, Function<T, String> stringFun) {
        this.classes.addAll(classes);
        int n = classes.size();
        this.matrix = new int[n][n];
        this.stringFun = stringFun;
    }

    ConfusionMatrix(Collection<T> classes) {
        this(classes, t -> t.toString());
    }

    void registerClassification(T trueClass, T assignedClass) {
        int indAssigned;
        int indTrue = this.classes.indexOf(trueClass);
        int n = indAssigned = trueClass == assignedClass ? indTrue : this.classes.indexOf(assignedClass);
        if (indTrue < 0 || indAssigned < 0) {
            ++this.errors;
            return;
        }
        int[] nArray = this.matrix[indTrue];
        int n2 = indAssigned;
        nArray[n2] = nArray[n2] + 1;
    }

    public String toString() {
        int nChars = 5;
        for (T pc : this.classes) {
            nChars = Math.max(nChars, this.stringFun.apply(pc).length());
        }
        String fString = "%1$" + nChars + "s";
        StringBuilder sb = new StringBuilder();
        sb.append(" ".repeat(nChars));
        for (T pc : this.classes) {
            sb.append("\t").append(String.format(fString, this.stringFun.apply(pc)));
        }
        sb.append("\n");
        for (int i = 0; i < this.classes.size(); ++i) {
            sb.append(String.format(fString, this.stringFun.apply(this.classes.get(i))));
            for (int j = 0; j < this.classes.size(); ++j) {
                sb.append("\t").append(String.format(fString, this.matrix[i][j]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

