/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.classifiers.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

class CompositeClassifier<T>
implements ObjectClassifier<T> {
    private List<ObjectClassifier<T>> classifiers;
    private transient Collection<PathClass> pathClasses;

    CompositeClassifier(Collection<ObjectClassifier<T>> classifiers) {
        this.classifiers = new ArrayList<ObjectClassifier<T>>(classifiers);
    }

    @Override
    public synchronized Collection<PathClass> getPathClasses() {
        if (this.pathClasses == null) {
            this.pathClasses = new LinkedHashSet<PathClass>();
            for (ObjectClassifier<T> c : this.classifiers) {
                this.pathClasses.addAll(c.getPathClasses());
            }
            this.pathClasses = Collections.unmodifiableCollection(this.pathClasses);
        }
        return this.pathClasses;
    }

    @Override
    public int classifyObjects(ImageData<T> imageData, boolean resetExistingClass) {
        return this.classifyObjects(imageData, this.getCompatibleObjects(imageData), resetExistingClass);
    }

    @Override
    public int classifyObjects(ImageData<T> imageData, Collection<? extends PathObject> pathObjects, boolean resetExistingClass) {
        Map<PathObject, PathClass> beforeMap = this.createMap(pathObjects);
        if (resetExistingClass) {
            pathObjects.stream().forEach(p -> p.resetPathClass());
        }
        for (ObjectClassifier<T> c : this.classifiers) {
            c.classifyObjects(imageData, pathObjects, false);
            if (!Thread.currentThread().isInterrupted()) continue;
            this.resetClassifications(pathObjects, beforeMap);
            return 0;
        }
        Map<PathObject, PathClass> afterMap = this.createMap(pathObjects);
        int n = 0;
        for (PathObject pathObject : pathObjects) {
            if (Objects.equals(beforeMap.get(pathObject), afterMap.get(pathObject))) continue;
            ++n;
        }
        return n;
    }

    Map<PathObject, PathClass> createMap(Collection<? extends PathObject> pathObjects) {
        HashMap<PathObject, PathClass> map = new HashMap<PathObject, PathClass>();
        for (PathObject pathObject : pathObjects) {
            map.put(pathObject, pathObject.getPathClass());
        }
        return map;
    }

    void resetClassifications(Collection<? extends PathObject> pathObjects, Map<PathObject, PathClass> map) {
        pathObjects.stream().forEach(p -> p.setPathClass((PathClass)map.get(p)));
    }

    @Override
    public Collection<PathObject> getCompatibleObjects(ImageData<T> imageData) {
        LinkedHashSet<PathObject> set = new LinkedHashSet<PathObject>();
        for (ObjectClassifier<T> classifier : this.classifiers) {
            set.addAll(classifier.getCompatibleObjects(imageData));
        }
        return set;
    }

    @Override
    public Map<String, Integer> getMissingFeatures(ImageData<T> imageData, Collection<? extends PathObject> pathObjects) {
        if (pathObjects == null) {
            pathObjects = this.getCompatibleObjects(imageData);
        }
        LinkedHashMap<String, Integer> missingFeatures = new LinkedHashMap<String, Integer>();
        for (ObjectClassifier<T> classifier : this.classifiers) {
            Map<String, Integer> newMissing = classifier.getMissingFeatures(imageData, pathObjects);
            if (newMissing.isEmpty()) continue;
            if (missingFeatures.isEmpty()) {
                missingFeatures.putAll(newMissing);
                continue;
            }
            for (Map.Entry<String, Integer> entry : newMissing.entrySet()) {
                missingFeatures.merge(entry.getKey(), entry.getValue(), (i, i2) -> Math.max(i, i2));
            }
        }
        return missingFeatures;
    }
}

