/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.classifiers.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import qupath.lib.classifiers.object.AbstractObjectClassifier;
import qupath.lib.classifiers.object.ObjectClassifiers;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;

class SimpleClassifier<T>
extends AbstractObjectClassifier<T> {
    private Function<PathObject, PathClass> function;
    private Collection<PathClass> pathClasses;

    SimpleClassifier(PathObjectFilter filter, Function<PathObject, PathClass> function, Collection<PathClass> pathClasses) {
        super(filter);
        this.function = function;
        this.pathClasses = Collections.unmodifiableList(new ArrayList<PathClass>(pathClasses));
    }

    @Override
    public Collection<PathClass> getPathClasses() {
        return this.pathClasses;
    }

    @Override
    public int classifyObjects(ImageData<T> imageData, Collection<? extends PathObject> pathObjects, boolean resetExistingClass) {
        int n = 0;
        for (PathObject pathObject : pathObjects) {
            PathClass pathClass;
            PathClass previousClass = pathObject.getPathClass();
            if (resetExistingClass) {
                pathObject.resetPathClass();
            }
            if ((pathClass = this.function.apply(pathObject)) != null) {
                PathClass currentClass = pathObject.getPathClass();
                if (currentClass == null) {
                    pathObject.setPathClass(pathClass);
                } else {
                    pathObject.setPathClass(PathClassTools.mergeClasses(currentClass, pathClass));
                }
            }
            if (previousClass == pathObject.getPathClass()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Map<String, Integer> getMissingFeatures(ImageData<T> imageData, Collection<? extends PathObject> pathObjects) {
        if (this.function instanceof ObjectClassifiers.ClassifyByMeasurementFunction) {
            int nMissing = 0;
            String name = ((ObjectClassifiers.ClassifyByMeasurementFunction)this.function).getMeasurement();
            if (name != null) {
                for (PathObject pathObject : pathObjects) {
                    if (pathObject.getMeasurementList().containsKey(name)) continue;
                    ++nMissing;
                }
            }
            if (nMissing > 0) {
                return Map.of(name, nMissing);
            }
        }
        return Collections.emptyMap();
    }
}

