/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.color;

public class ColorDeconvMatrix3x3 {
    private final double m11;
    private final double m12;
    private final double m13;
    private final double m21;
    private final double m22;
    private final double m23;
    private final double m31;
    private final double m32;
    private final double m33;

    public ColorDeconvMatrix3x3(double[][] M) throws IllegalArgumentException {
        if (M.length != 3 || M[0].length != 3 || M[1].length != 3 || M[2].length != 3) {
            throw new IllegalArgumentException("Invalid matrix size! Must be 3x3.");
        }
        this.m11 = M[0][0];
        this.m12 = M[0][1];
        this.m13 = M[0][2];
        this.m21 = M[1][0];
        this.m22 = M[1][1];
        this.m23 = M[1][2];
        this.m31 = M[2][0];
        this.m32 = M[2][1];
        this.m33 = M[2][2];
    }

    private static double det2(double a11, double a12, double a21, double a22) {
        return a11 * a22 - a12 * a21;
    }

    public double determinant() {
        return this.m11 * ColorDeconvMatrix3x3.det2(this.m22, this.m23, this.m32, this.m33) - this.m12 * ColorDeconvMatrix3x3.det2(this.m21, this.m23, this.m31, this.m33) + this.m13 * ColorDeconvMatrix3x3.det2(this.m21, this.m22, this.m31, this.m32);
    }

    public double[][] inverse() {
        double invDet3 = 1.0 / this.determinant();
        return new double[][]{{invDet3 * ColorDeconvMatrix3x3.det2(this.m22, this.m23, this.m32, this.m33), invDet3 * ColorDeconvMatrix3x3.det2(this.m13, this.m12, this.m33, this.m32), invDet3 * ColorDeconvMatrix3x3.det2(this.m12, this.m13, this.m22, this.m23)}, {invDet3 * ColorDeconvMatrix3x3.det2(this.m23, this.m21, this.m33, this.m31), invDet3 * ColorDeconvMatrix3x3.det2(this.m11, this.m13, this.m31, this.m33), invDet3 * ColorDeconvMatrix3x3.det2(this.m13, this.m11, this.m23, this.m21)}, {invDet3 * ColorDeconvMatrix3x3.det2(this.m21, this.m22, this.m31, this.m32), invDet3 * ColorDeconvMatrix3x3.det2(this.m12, this.m11, this.m32, this.m31), invDet3 * ColorDeconvMatrix3x3.det2(this.m11, this.m12, this.m21, this.m22)}};
    }

    public String toString() {
        return "Matrix:\n " + this.m11 + ", " + this.m12 + ", " + this.m13 + "\n" + this.m21 + ", " + this.m22 + ", " + this.m23 + "\n" + this.m31 + ", " + this.m32 + ", " + this.m33 + "\n";
    }
}

