/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.color;

import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorMaps;
import qupath.lib.color.DefaultColorModel;
import qupath.lib.color.DummyColorModel;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.PixelType;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;

public final class ColorModelFactory {
    private static final Logger logger = LoggerFactory.getLogger(ColorModelFactory.class);
    private static Map<List<ImageChannel>, ColorModel> probabilityModels8 = Collections.synchronizedMap(new HashMap());
    private static Map<List<ImageChannel>, ColorModel> probabilityModels32 = Collections.synchronizedMap(new HashMap());

    private ColorModelFactory() {
        throw new AssertionError();
    }

    public static IndexColorModel getIndexedClassificationColorModel(Map<Integer, PathClass> channels) {
        IntSummaryStatistics stats = channels.keySet().stream().mapToInt(c -> c).summaryStatistics();
        if (stats.getMin() < 0) {
            throw new IllegalArgumentException("Minimum label must be >= 0");
        }
        int length = stats.getMax() + 1;
        int[] cmap = new int[length];
        for (Map.Entry<Integer, PathClass> entry : channels.entrySet()) {
            PathClass pathClass = entry.getValue();
            if (pathClass == null || pathClass == PathClass.NULL_CLASS) {
                cmap[entry.getKey().intValue()] = ColorTools.packARGB(0, 255, 255, 255);
                continue;
            }
            if (PathClassTools.isIgnoredClass(entry.getValue())) {
                int color = pathClass == null ? 0 : pathClass.getColor();
                int alpha = 192;
                if (pathClass == PathClass.StandardPathClasses.IGNORE) {
                    alpha = 32;
                }
                cmap[entry.getKey().intValue()] = ColorTools.packARGB(alpha, ColorTools.red(color), ColorTools.green(color), ColorTools.blue(color));
                continue;
            }
            cmap[entry.getKey().intValue()] = entry.getValue().getColor();
        }
        if (cmap.length <= 256) {
            return new IndexColorModel(8, length, cmap, 0, true, -1, 0);
        }
        if (cmap.length <= 65536) {
            return new IndexColorModel(16, length, cmap, 0, true, -1, 1);
        }
        throw new IllegalArgumentException("Only 65536 possible classifications supported!");
    }

    public static ColorModel createIndexedColorModel(Map<Integer, Integer> labelColors, boolean includeAlpha) {
        IntSummaryStatistics stats = labelColors.keySet().stream().mapToInt(c -> c).summaryStatistics();
        if (stats.getMin() < 0) {
            throw new IllegalArgumentException("Minimum label must be >= 0");
        }
        int length = stats.getMax() + 1;
        int[] cmap = new int[length];
        for (Map.Entry<Integer, Integer> entry : labelColors.entrySet()) {
            Integer value = entry.getValue();
            if (value == null) {
                logger.warn("No color specified for index {} - using default gray", (Object)entry.getKey());
                cmap[entry.getKey().intValue()] = includeAlpha ? ColorTools.packARGB(127, 127, 127, 127) : ColorTools.packRGB(127, 127, 127);
                continue;
            }
            cmap[entry.getKey().intValue()] = entry.getValue();
        }
        if (cmap.length <= 256) {
            return new IndexColorModel(8, length, cmap, 0, includeAlpha, -1, 0);
        }
        if (cmap.length <= 65536) {
            return new IndexColorModel(16, length, cmap, 0, includeAlpha, -1, 1);
        }
        throw new IllegalArgumentException("Only 65536 possible labels supported!");
    }

    public static IndexColorModel createIndexedColorModel8bit(ColorMaps.ColorMap map) {
        return ColorModelFactory.createIndexedColorModel8bit(map, -1);
    }

    public static IndexColorModel createIndexedColorModel8bit(ColorMaps.ColorMap map, int transparentPixel) {
        Objects.requireNonNull(map);
        return new IndexColorModel(8, 256, ColorMaps.getColors(map, 256, false), 0, false, transparentPixel, 0);
    }

    public static ColorModel createColorModel(PixelType pixelType, ColorMaps.ColorMap map, int band) {
        return ColorModelFactory.createColorModel(pixelType, map, band, 0.0, pixelType.isFloatingPoint() ? 1.0 : pixelType.getUpperBound().doubleValue(), -1, null);
    }

    public static ColorModel createColorModel(PixelType pixelType, ColorMaps.ColorMap map, int band, double min, double max, int alphaChannel, DoubleToIntFunction alphaFun) {
        Objects.requireNonNull(map);
        if (alphaFun == null && alphaChannel >= 0) {
            alphaFun = ColorModelFactory.createLinearFunction(pixelType);
        }
        return new ColorMapModel(pixelType, map, band, min, max, alphaChannel, alphaFun);
    }

    public static DoubleToIntFunction createLinearFunction(PixelType type) {
        return ColorModelFactory.createLinearFunction(0.0, type.isFloatingPoint() ? 1.0 : type.getUpperBound().doubleValue());
    }

    public static DoubleToIntFunction createLinearFunction(double min, double max) {
        return d -> (int)GeneralTools.clipValue(Math.round(255.0 * (d - min) / (max - min)), 0.0, 255.0);
    }

    public static DoubleToIntFunction createGammaFunction(double gamma, PixelType type) {
        return ColorModelFactory.createGammaFunction(gamma, 0.0, type.isFloatingPoint() ? 1.0 : type.getUpperBound().doubleValue());
    }

    public static DoubleToIntFunction createGammaFunction(double gamma, double min, double max) {
        return d -> ColorModelFactory.gamma(d, min, max, gamma);
    }

    private static int gamma(double val, double min, double max, double gamma) {
        val -= min;
        val /= Math.abs(max - min);
        if (gamma != 1.0) {
            val = Math.pow(val, gamma);
        }
        val = GeneralTools.clipValue(val, 0.0, 1.0);
        return (int)Math.round(val * 255.0);
    }

    public static ColorModel getProbabilityColorModel8Bit(List<ImageChannel> channels) {
        ColorModel map = probabilityModels8.get(channels);
        if (map == null) {
            int[] colors = channels.stream().mapToInt(c -> c.getColor()).toArray();
            map = ColorModelFactory.createColorModel(PixelType.UINT8, channels.size(), channels.size() == 1, colors);
            probabilityModels8.put(new ArrayList<ImageChannel>(channels), map);
        }
        return map;
    }

    public static ColorModel getProbabilityColorModel32Bit(List<ImageChannel> channels) {
        ColorModel map = probabilityModels32.get(channels);
        if (map == null) {
            int[] colors = channels.stream().mapToInt(c -> c.getColor()).toArray();
            map = ColorModelFactory.createColorModel(PixelType.FLOAT32, channels.size(), channels.size() == 1, colors);
            probabilityModels32.put(new ArrayList<ImageChannel>(channels), map);
        }
        return map;
    }

    public static ColorModel getDummyColorModel(int bpp) {
        return new DummyColorModel(bpp);
    }

    public static ColorModel createColorModel(PixelType type, int nChannels, boolean alphaResidual, int ... colors) {
        return new DefaultColorModel(type, nChannels, alphaResidual, colors);
    }

    public static ColorModel createColorModel(PixelType type, List<? extends ImageChannel> channels) {
        return new DefaultColorModel(type, channels.size(), false, channels.stream().mapToInt(c -> {
            Integer color = c.getColor();
            if (color == null) {
                color = ColorTools.packRGB(255, 255, 255);
            }
            return color;
        }).toArray());
    }

    static class ColorMapModel
    extends DefaultAbstractColorModel {
        private ColorMaps.ColorMap map;
        private double min;
        private double max;
        private int band = 0;
        private int nBits;
        private boolean hasAlphaChannel;
        private boolean isSigned;
        private int alphaChannel;
        private DoubleToIntFunction alphaFun;

        public ColorMapModel(PixelType pixelType, ColorMaps.ColorMap map, int band, double min, double max, int alphaChannel, DoubleToIntFunction alphaFun) {
            super(pixelType, Math.max(1, alphaChannel + 1));
            this.band = band;
            this.nBits = pixelType.getBitsPerPixel();
            this.isSigned = pixelType.isSignedInteger();
            this.map = map;
            this.min = min;
            this.max = max;
            this.hasAlphaChannel = alphaChannel >= 0;
            this.alphaChannel = alphaChannel;
            this.alphaFun = alphaFun;
        }

        @Override
        public int getRed(int pixel) {
            return ColorTools.red(this.map.getColor(pixel, this.min, this.max));
        }

        @Override
        public int getGreen(int pixel) {
            return ColorTools.green(this.map.getColor(pixel, this.min, this.max));
        }

        @Override
        public int getBlue(int pixel) {
            return ColorTools.blue(this.map.getColor(pixel, this.min, this.max));
        }

        @Override
        public int getAlpha(int pixel) {
            if (this.hasAlphaChannel) {
                pixel <<= this.nBits * this.alphaChannel;
            }
            return this.alphaFun == null ? 255 : this.alphaFun.applyAsInt(pixel);
        }

        private double extractByteValue(byte b) {
            return this.isSigned ? (double)b : (double)(b & 0xFF);
        }

        private double extractShortValue(short s) {
            return this.isSigned ? (double)s : (double)(s & 0xFFFF);
        }

        @Override
        protected int getRedByte(byte[] pixel) {
            return this.getRed(this.extractByteValue(pixel[this.band]));
        }

        @Override
        protected int getGreenByte(byte[] pixel) {
            return this.getGreen(this.extractByteValue(pixel[this.band]));
        }

        @Override
        protected int getBlueByte(byte[] pixel) {
            return this.getBlue(this.extractByteValue(pixel[this.band]));
        }

        @Override
        protected int getAlphaByte(byte[] pixel) {
            return this.getAlpha(this.extractByteValue(pixel[this.hasAlphaChannel ? this.alphaChannel : 0]));
        }

        @Override
        protected int getRedFloat(float[] pixel) {
            return this.getRed(pixel[0]);
        }

        @Override
        protected int getGreenFloat(float[] pixel) {
            return this.getGreen(pixel[0]);
        }

        @Override
        protected int getBlueFloat(float[] pixel) {
            return this.getBlue(pixel[0]);
        }

        @Override
        protected int getAlphaFloat(float[] pixel) {
            return this.hasAlphaChannel ? this.getAlpha(pixel[this.alphaChannel]) : this.getAlpha(pixel[0]);
        }

        @Override
        protected int getRedDouble(double[] pixel) {
            return this.getRed(pixel[0]);
        }

        @Override
        protected int getGreenDouble(double[] pixel) {
            return this.getGreen(pixel[0]);
        }

        @Override
        protected int getBlueDouble(double[] pixel) {
            return this.getBlue(pixel[0]);
        }

        @Override
        protected int getAlphaDouble(double[] pixel) {
            return this.hasAlphaChannel ? this.getAlpha(pixel[this.alphaChannel]) : this.getAlpha(pixel[0]);
        }

        @Override
        protected int getRedShort(short[] pixel) {
            return this.getRed(this.extractShortValue(pixel[this.band]));
        }

        @Override
        protected int getGreenShort(short[] pixel) {
            return this.getGreen(this.extractShortValue(pixel[this.band]));
        }

        @Override
        protected int getBlueShort(short[] pixel) {
            return this.getBlue(this.extractShortValue(pixel[this.band]));
        }

        @Override
        protected int getAlphaShort(short[] pixel) {
            return this.getAlpha(this.extractShortValue(pixel[this.hasAlphaChannel ? this.alphaChannel : 0]));
        }

        @Override
        protected int getRedInt(int[] pixel) {
            return this.getRed(pixel[this.band]);
        }

        @Override
        protected int getGreenInt(int[] pixel) {
            return this.getGreen(pixel[this.band]);
        }

        @Override
        protected int getBlueInt(int[] pixel) {
            return this.getBlue(pixel[this.band]);
        }

        @Override
        protected int getAlphaInt(int[] pixel) {
            return this.hasAlphaChannel ? this.getAlpha(pixel[this.alphaChannel]) : this.getAlpha(pixel[0]);
        }

        public int getRed(double pixel) {
            return ColorTools.red(this.map.getColor(pixel, this.min, this.max));
        }

        public int getGreen(double pixel) {
            return ColorTools.green(this.map.getColor(pixel, this.min, this.max));
        }

        public int getBlue(double pixel) {
            return ColorTools.blue(this.map.getColor(pixel, this.min, this.max));
        }

        public int getAlpha(double pixel) {
            return this.alphaFun == null ? 255 : this.alphaFun.applyAsInt(pixel);
        }
    }

    static abstract class DefaultAbstractColorModel
    extends ColorModel {
        private PixelType pixelType;
        private int nBands;

        DefaultAbstractColorModel(PixelType pixelType, int nBands) {
            super(pixelType.getBitsPerPixel() * nBands);
            this.pixelType = pixelType;
            this.nBands = nBands;
        }

        @Override
        public int getRed(Object pixel) {
            if (pixel instanceof byte[]) {
                return this.getRedByte((byte[])pixel);
            }
            if (pixel instanceof float[]) {
                return this.getRedFloat((float[])pixel);
            }
            if (pixel instanceof short[]) {
                return this.getRedShort((short[])pixel);
            }
            if (pixel instanceof int[]) {
                return this.getRedInt((int[])pixel);
            }
            if (pixel instanceof double[]) {
                return this.getRedDouble((double[])pixel);
            }
            return 0;
        }

        @Override
        public int getGreen(Object pixel) {
            if (pixel instanceof byte[]) {
                return this.getGreenByte((byte[])pixel);
            }
            if (pixel instanceof float[]) {
                return this.getGreenFloat((float[])pixel);
            }
            if (pixel instanceof short[]) {
                return this.getGreenShort((short[])pixel);
            }
            if (pixel instanceof int[]) {
                return this.getGreenInt((int[])pixel);
            }
            if (pixel instanceof double[]) {
                return this.getGreenDouble((double[])pixel);
            }
            return 0;
        }

        @Override
        public int getBlue(Object pixel) {
            if (pixel instanceof byte[]) {
                return this.getBlueByte((byte[])pixel);
            }
            if (pixel instanceof float[]) {
                return this.getBlueFloat((float[])pixel);
            }
            if (pixel instanceof short[]) {
                return this.getBlueShort((short[])pixel);
            }
            if (pixel instanceof int[]) {
                return this.getBlueInt((int[])pixel);
            }
            if (pixel instanceof double[]) {
                return this.getBlueDouble((double[])pixel);
            }
            return 0;
        }

        @Override
        public int getAlpha(Object pixel) {
            if (pixel instanceof byte[]) {
                return this.getAlphaByte((byte[])pixel);
            }
            if (pixel instanceof float[]) {
                return this.getAlphaFloat((float[])pixel);
            }
            if (pixel instanceof short[]) {
                return this.getAlphaShort((short[])pixel);
            }
            if (pixel instanceof int[]) {
                return this.getAlphaInt((int[])pixel);
            }
            if (pixel instanceof double[]) {
                return this.getAlphaDouble((double[])pixel);
            }
            return 255;
        }

        protected abstract int getRedByte(byte[] var1);

        protected abstract int getGreenByte(byte[] var1);

        protected abstract int getBlueByte(byte[] var1);

        protected abstract int getAlphaByte(byte[] var1);

        protected abstract int getRedFloat(float[] var1);

        protected abstract int getGreenFloat(float[] var1);

        protected abstract int getBlueFloat(float[] var1);

        protected abstract int getAlphaFloat(float[] var1);

        protected abstract int getRedDouble(double[] var1);

        protected abstract int getGreenDouble(double[] var1);

        protected abstract int getBlueDouble(double[] var1);

        protected abstract int getAlphaDouble(double[] var1);

        protected abstract int getRedShort(short[] var1);

        protected abstract int getGreenShort(short[] var1);

        protected abstract int getBlueShort(short[] var1);

        protected abstract int getAlphaShort(short[] var1);

        protected abstract int getRedInt(int[] var1);

        protected abstract int getGreenInt(int[] var1);

        protected abstract int getBlueInt(int[] var1);

        protected abstract int getAlphaInt(int[] var1);

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            int transferType = raster.getTransferType();
            return transferType == 0 || transferType == 1 || transferType == 3 || transferType == 2 || transferType == 4 || transferType == 5;
        }

        @Override
        public WritableRaster createCompatibleWritableRaster(int w, int h) {
            switch (this.pixelType) {
                case FLOAT32: {
                    return WritableRaster.createWritableRaster(new BandedSampleModel(4, w, h, this.nBands), new DataBufferFloat(w * h, this.nBands), null);
                }
                case FLOAT64: {
                    return WritableRaster.createWritableRaster(new BandedSampleModel(5, w, h, this.nBands), new DataBufferDouble(w * h, this.nBands), null);
                }
                case INT16: {
                    return WritableRaster.createWritableRaster(new BandedSampleModel(2, w, h, this.nBands), new DataBufferShort(w * h, this.nBands), null);
                }
                case INT32: {
                    return WritableRaster.createBandedRaster(3, w, h, this.nBands, null);
                }
                case UINT16: {
                    return WritableRaster.createBandedRaster(1, w, h, this.nBands, null);
                }
                case UINT8: {
                    return WritableRaster.createBandedRaster(0, w, h, this.nBands, null);
                }
            }
            try {
                return super.createCompatibleWritableRaster(w, h);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Unsupported pixel type " + String.valueOf((Object)this.pixelType));
            }
        }

        @Override
        public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
            logger.warn("Unsupported call to coerce data for {} (isAlphaPremultiplied = {})", (Object)raster, (Object)isAlphaPremultiplied);
            return null;
        }
    }
}

