/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.color;

import java.awt.image.ColorModel;
import java.util.Objects;
import java.util.function.DoubleToIntFunction;
import qupath.lib.color.ColorMaps;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.images.servers.PixelType;
import qupath.lib.io.GsonTools;

public class ColorModels {
    private static GsonTools.SubTypeAdapterFactory<ColorModelBuilder> factory = GsonTools.createSubTypeAdapterFactory(ColorModelBuilder.class, "type").registerSubtype(SingleChannelColorModelBuilder.class);

    public static ColorModelBuilder createColorModelBuilder(DisplayBand mainChannel, DisplayBand alphaChannel) {
        return new SingleChannelColorModelBuilder(mainChannel, alphaChannel);
    }

    public static DisplayBand createBand(String colorMapName, int band, double minDisplay, double maxDisplay) {
        return ColorModels.createBand(colorMapName, band, minDisplay, maxDisplay, 1.0);
    }

    public static DisplayBand createBand(String colorMapName, int band, double minDisplay, double maxDisplay, double gamma) {
        return new DisplayBand(colorMapName, null, band, minDisplay, maxDisplay, gamma);
    }

    private static ColorModel buildColorModel(ColorMaps.ColorMap colorMap, int band, double minDisplay, double maxDisplay, int alphaCountBand, double minAlpha, double maxAlpha, double alphaGamma) {
        DoubleToIntFunction alphaFun = null;
        if (alphaCountBand < 0) {
            if (alphaGamma <= 0.0) {
                alphaFun = null;
                alphaCountBand = -1;
            } else {
                alphaFun = ColorModelFactory.createGammaFunction(alphaGamma, minAlpha, maxAlpha);
                alphaCountBand = 0;
            }
        } else if (alphaFun == null) {
            alphaFun = alphaGamma < 0.0 ? d -> 255 : (alphaGamma == 0.0 ? d -> d > minAlpha ? 255 : 0 : ColorModelFactory.createGammaFunction(alphaGamma, minAlpha, maxAlpha));
        }
        return ColorModelFactory.createColorModel(PixelType.FLOAT32, colorMap, band, minDisplay, maxDisplay, alphaCountBand, alphaFun);
    }

    static {
        GsonTools.getDefaultBuilder().registerTypeAdapterFactory(factory);
    }

    static class SingleChannelColorModelBuilder
    implements ColorModelBuilder {
        private DisplayBand band;
        private DisplayBand alphaBand;

        private SingleChannelColorModelBuilder(DisplayBand band, DisplayBand alphaBand) {
            Objects.requireNonNull(band);
            this.band = band;
            this.alphaBand = alphaBand;
        }

        @Override
        public ColorModel build() {
            ColorMaps.ColorMap map = this.band.getColorMap();
            if (map == null) {
                map = ColorMaps.getDefaultColorMap();
            }
            if (this.band.gamma != 1.0) {
                map = ColorMaps.gammaColorMap(map, this.band.gamma);
            }
            int alphaBandInd = -1;
            double alphaMin = 0.0;
            double alphaMax = 1.0;
            double alphaGamma = -1.0;
            if (this.alphaBand != null) {
                alphaBandInd = this.alphaBand.band;
                alphaMin = this.alphaBand.minDisplay;
                alphaMax = this.alphaBand.maxDisplay;
                alphaGamma = this.alphaBand.gamma;
            }
            return ColorModels.buildColorModel(map, this.band.band, this.band.minDisplay, this.band.maxDisplay, alphaBandInd, alphaMin, alphaMax, alphaGamma);
        }
    }

    public static class DisplayBand {
        private String colorMapName;
        private ColorMaps.ColorMap colorMap;
        private int band;
        private double minDisplay;
        private double maxDisplay;
        private double gamma = 1.0;

        private DisplayBand(String colorMapName, ColorMaps.ColorMap colorMap, int band, double minDisplay, double maxDisplay, double gamma) {
            this.colorMapName = colorMapName;
            this.colorMap = colorMap;
            this.band = band;
            this.minDisplay = minDisplay;
            this.maxDisplay = maxDisplay;
            this.gamma = gamma;
        }

        private ColorMaps.ColorMap getColorMap() {
            if (this.colorMap != null) {
                return this.colorMap;
            }
            if (this.colorMapName != null) {
                return ColorMaps.getColorMaps().getOrDefault(this.colorMapName, null);
            }
            return null;
        }
    }

    public static interface ColorModelBuilder {
        public ColorModel build();
    }
}

