/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.color;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import qupath.lib.color.StainVector;
import qupath.lib.common.ColorTools;

public class ColorToolsAwt {
    private static Map<Integer, Color> colorMap = new HashMap<Integer, Color>();
    private static Map<Integer, Color> colorMapWithAlpha = new HashMap<Integer, Color>();
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final Lock r = rwl.readLock();
    private static final Lock w = rwl.writeLock();
    private static Map<Color, Color> colorsTransparent = Collections.synchronizedMap(new HashMap());
    private static Map<Color, Color> colorsDarkened = Collections.synchronizedMap(new HashMap());
    private static Map<Color, Color> colorsMoreTransparent = Collections.synchronizedMap(new HashMap());
    public static final Color TRANSLUCENT_WHITE = new Color(255, 255, 255, 128);
    public static final Color TRANSLUCENT_BLACK = new Color(0, 0, 0, 128);

    public static Color getCachedColor(int r, int g, int b, int a) {
        return ColorToolsAwt.getCachedColor(ColorTools.packARGB(a, r, g, b));
    }

    public static Color getCachedColor(int r, int g, int b) {
        return ColorToolsAwt.getCachedColor(ColorTools.packRGB(r, g, b));
    }

    public static Color getCachedColor(Integer rgb) {
        return ColorToolsAwt.getCachedColor(rgb, ColorTools.alpha(rgb) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getCachedColor(Integer rgb, boolean hasAlpha) {
        Color color;
        if (rgb == null) {
            return null;
        }
        r.lock();
        try {
            Color color2 = color = hasAlpha ? colorMapWithAlpha.get(rgb) : colorMap.get(rgb);
            if (color != null) {
                Color color3 = color;
                return color3;
            }
        }
        finally {
            r.unlock();
        }
        w.lock();
        try {
            color = new Color(rgb, hasAlpha);
            if (hasAlpha) {
                colorMapWithAlpha.put(rgb, color);
            } else {
                colorMap.put(rgb, color);
            }
            Color color4 = color;
            return color4;
        }
        finally {
            w.unlock();
        }
    }

    static IndexColorModel createIndexColorModel(int red, int green, int blue) {
        byte[] rLut = new byte[256];
        byte[] gLut = new byte[256];
        byte[] bLut = new byte[256];
        double rIncr = (double)red / 255.0;
        double gIncr = (double)green / 255.0;
        double bIncr = (double)blue / 255.0;
        for (int i = 0; i < 256; ++i) {
            rLut[i] = (byte)((double)i * rIncr);
            gLut[i] = (byte)((double)i * gIncr);
            bLut[i] = (byte)((double)i * bIncr);
        }
        return new IndexColorModel(8, 256, rLut, gLut, bLut);
    }

    public static IndexColorModel getIndexColorModel(StainVector stain, boolean whiteBackground) {
        int c = stain.getColor();
        return ColorToolsAwt.createIndexColorModel(ColorTools.red(c), ColorTools.green(c), ColorTools.blue(c), whiteBackground);
    }

    public static IndexColorModel createIndexColorModel(int red, int green, int blue, boolean whiteBackground) {
        if (!whiteBackground) {
            return ColorToolsAwt.createIndexColorModel(red, green, blue);
        }
        red = 255 - red;
        green = 255 - green;
        blue = 255 - blue;
        byte[] r2 = new byte[256];
        byte[] g2 = new byte[256];
        byte[] b2 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r2[i] = (byte)ColorTools.clip255(255.0 - (double)red / 255.0 * (double)i);
            g2[i] = (byte)ColorTools.clip255(255.0 - (double)green / 255.0 * (double)i);
            b2[i] = (byte)ColorTools.clip255(255.0 - (double)blue / 255.0 * (double)i);
        }
        return new IndexColorModel(8, 256, r2, g2, b2);
    }

    static IndexColorModel createHueColorModel() {
        byte[] r2 = new byte[256];
        byte[] g2 = new byte[256];
        byte[] b2 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            int rgb = Color.HSBtoRGB((float)i / 255.0f, 1.0f, 0.75f);
            r2[i] = (byte)ColorTools.red(rgb);
            g2[i] = (byte)ColorTools.green(rgb);
            b2[i] = (byte)ColorTools.blue(rgb);
        }
        return new IndexColorModel(8, 256, r2, g2, b2);
    }

    public static IndexColorModel getIndexColorModel(StainVector stain) {
        return ColorToolsAwt.getIndexColorModel(stain, true);
    }

    public static Color getMoreTranslucentColor(Color color) {
        Color colorTranslucent = colorsMoreTransparent.get(color);
        if (colorTranslucent == null) {
            colorTranslucent = ColorToolsAwt.getColorWithOpacity(color, 0.3);
            colorsMoreTransparent.put(color, colorTranslucent);
        }
        return colorTranslucent;
    }

    public static Color darkenColor(Color color) {
        Color colorDarkened = colorsDarkened.get(color);
        if (colorDarkened == null) {
            colorDarkened = ColorToolsAwt.scaleColor(color, 0.8);
            colorsDarkened.put(color, colorDarkened);
        }
        return colorDarkened;
    }

    public static Color getTranslucentColor(Color color) {
        Color colorTranslucent = colorsTransparent.get(color);
        colorsTransparent.clear();
        if (colorTranslucent == null) {
            colorTranslucent = ColorToolsAwt.getColorWithOpacity(color, 0.8);
            colorsTransparent.put(color, colorTranslucent);
        }
        return colorTranslucent;
    }

    public static Color scaleColor(Color color, double factor) {
        return new Color(ColorTools.do8BitRangeCheck((double)color.getRed() * factor), ColorTools.do8BitRangeCheck((double)color.getGreen() * factor), ColorTools.do8BitRangeCheck((double)color.getBlue() * factor), color.getAlpha());
    }

    public static Color getColorWithOpacity(Integer rgb, double opacity) {
        if (rgb == null) {
            return null;
        }
        if (opacity > 1.0) {
            opacity = 1.0;
        } else if (opacity < 0.0) {
            opacity = 0.0;
        }
        return new Color(ColorTools.red(rgb), ColorTools.green(rgb), ColorTools.blue(rgb), (int)(opacity * 255.0 + 0.5));
    }

    public static Color getColorWithOpacity(Color color, double opacity) {
        if (color == null) {
            return null;
        }
        if (opacity > 1.0) {
            opacity = 1.0;
        } else if (opacity < 0.0) {
            opacity = 0.0;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(opacity * 255.0 + 0.5));
    }
}

