/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.color;

import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.images.servers.PixelType;

class DefaultColorModel
extends ColorModel {
    private static final Logger logger = LoggerFactory.getLogger(DefaultColorModel.class);
    public static final int BACKGROUND_COLOR = ColorTools.packARGB(0, 255, 253, 254);
    private static int[] DEFAULT_COLORS = new int[]{ColorTools.packRGB(255, 0, 0), ColorTools.packRGB(0, 255, 0), ColorTools.packRGB(0, 0, 255), ColorTools.packRGB(255, 0, 255), ColorTools.packRGB(0, 255, 255), ColorTools.packRGB(255, 255, 0)};
    private PixelType pixelType;
    private int nBands;
    private boolean residualBackground = false;
    private int backgroundChannel = -1;
    private float[] rScale;
    private float[] gScale;
    private float[] bScale;

    DefaultColorModel(PixelType pixelType, int nBands, boolean residualBackground, int ... colors) {
        super(pixelType.getBitsPerPixel() * nBands);
        this.pixelType = pixelType;
        this.nBands = nBands;
        this.residualBackground = residualBackground;
        if (colors.length == 0) {
            colors = DEFAULT_COLORS;
        }
        this.rScale = new float[nBands];
        this.gScale = new float[nBands];
        this.bScale = new float[nBands];
        for (int i = 0; i < Math.min(colors.length, nBands); ++i) {
            int val = colors[i];
            if (val == BACKGROUND_COLOR) {
                this.backgroundChannel = i;
                continue;
            }
            int r = ColorTools.red(val);
            int g = ColorTools.green(val);
            int b = ColorTools.blue(val);
            this.rScale[i] = (float)r / 255.0f;
            this.gScale[i] = (float)g / 255.0f;
            this.bScale[i] = (float)b / 255.0f;
        }
    }

    @Override
    public int getRed(int pixel) {
        return 0;
    }

    @Override
    public int getGreen(int pixel) {
        return 0;
    }

    @Override
    public int getBlue(int pixel) {
        return 0;
    }

    @Override
    public int getAlpha(int pixel) {
        return 0;
    }

    @Override
    public int getRed(Object pixel) {
        if (pixel instanceof byte[]) {
            return this.getRedByte((byte[])pixel);
        }
        if (pixel instanceof float[]) {
            return this.getRedFloat((float[])pixel);
        }
        if (pixel instanceof short[]) {
            return this.getRedShort((short[])pixel);
        }
        if (pixel instanceof int[]) {
            return this.getRedInt((int[])pixel);
        }
        if (pixel instanceof double[]) {
            return this.getRedDouble((double[])pixel);
        }
        return 0;
    }

    @Override
    public int getGreen(Object pixel) {
        if (pixel instanceof byte[]) {
            return this.getGreenByte((byte[])pixel);
        }
        if (pixel instanceof float[]) {
            return this.getGreenFloat((float[])pixel);
        }
        if (pixel instanceof short[]) {
            return this.getGreenShort((short[])pixel);
        }
        if (pixel instanceof int[]) {
            return this.getGreenInt((int[])pixel);
        }
        if (pixel instanceof double[]) {
            return this.getGreenDouble((double[])pixel);
        }
        return 0;
    }

    @Override
    public int getBlue(Object pixel) {
        if (pixel instanceof byte[]) {
            return this.getBlueByte((byte[])pixel);
        }
        if (pixel instanceof float[]) {
            return this.getBlueFloat((float[])pixel);
        }
        if (pixel instanceof short[]) {
            return this.getBlueShort((short[])pixel);
        }
        if (pixel instanceof int[]) {
            return this.getBlueInt((int[])pixel);
        }
        if (pixel instanceof double[]) {
            return this.getBlueDouble((double[])pixel);
        }
        return 0;
    }

    @Override
    public int getAlpha(Object pixel) {
        if (pixel instanceof byte[]) {
            return this.getAlphaByte((byte[])pixel);
        }
        if (pixel instanceof float[]) {
            return this.getAlphaFloat((float[])pixel);
        }
        if (pixel instanceof short[]) {
            return this.getAlphaShort((short[])pixel);
        }
        if (pixel instanceof int[]) {
            return this.getAlphaInt((int[])pixel);
        }
        if (pixel instanceof double[]) {
            return this.getAlphaDouble((double[])pixel);
        }
        return 255;
    }

    private int getRedByte(byte[] pixel) {
        return this.scaledPixelColor(pixel, this.rScale);
    }

    private int getGreenByte(byte[] pixel) {
        return this.scaledPixelColor(pixel, this.gScale);
    }

    private int getBlueByte(byte[] pixel) {
        return this.scaledPixelColor(pixel, this.bScale);
    }

    private int getAlphaByte(byte[] pixel) {
        if (this.backgroundChannel >= 0) {
            return (int)(255.0f * (1.0f - DefaultColorModel.byteToFloat(pixel[this.backgroundChannel])));
        }
        if (this.residualBackground) {
            float sum = 0.0f;
            for (byte p : pixel) {
                sum += DefaultColorModel.byteToFloat(p);
            }
            return (int)(255.0f * DefaultColorModel.clipFloat(sum));
        }
        return 255;
    }

    private int getRedFloat(float[] pixel) {
        return this.scaledPixelColor(pixel, this.rScale);
    }

    private int getGreenFloat(float[] pixel) {
        return this.scaledPixelColor(pixel, this.gScale);
    }

    private int getBlueFloat(float[] pixel) {
        return this.scaledPixelColor(pixel, this.bScale);
    }

    private int getAlphaFloat(float[] pixel) {
        if (this.backgroundChannel >= 0) {
            return (int)(255.0f * DefaultColorModel.clipFloat(1.0f - pixel[this.backgroundChannel]));
        }
        if (this.residualBackground) {
            float sum = 0.0f;
            for (float p : pixel) {
                sum += DefaultColorModel.clipFloat(p);
            }
            return (int)(255.0f * DefaultColorModel.clipFloat(sum));
        }
        return 255;
    }

    private int getRedDouble(double[] pixel) {
        return this.scaledPixelColor(pixel, this.rScale);
    }

    private int getGreenDouble(double[] pixel) {
        return this.scaledPixelColor(pixel, this.gScale);
    }

    private int getBlueDouble(double[] pixel) {
        return this.scaledPixelColor(pixel, this.bScale);
    }

    private int getAlphaDouble(double[] pixel) {
        if (this.backgroundChannel >= 0) {
            return (int)(255.0 * (1.0 - pixel[this.backgroundChannel]));
        }
        if (this.residualBackground) {
            float sum = 0.0f;
            for (double p : pixel) {
                sum += DefaultColorModel.clipFloat(p);
            }
            return (int)(255.0f * DefaultColorModel.clipFloat(sum));
        }
        return 255;
    }

    private int getRedShort(short[] pixel) {
        if (this.pixelType == PixelType.UINT16) {
            return this.scaledPixelColorU16(pixel, this.rScale);
        }
        return this.scaledPixelColorSigned16(pixel, this.rScale);
    }

    private int getGreenShort(short[] pixel) {
        if (this.pixelType == PixelType.UINT16) {
            return this.scaledPixelColorU16(pixel, this.gScale);
        }
        return this.scaledPixelColorSigned16(pixel, this.gScale);
    }

    private int getBlueShort(short[] pixel) {
        if (this.pixelType == PixelType.UINT16) {
            return this.scaledPixelColorU16(pixel, this.bScale);
        }
        return this.scaledPixelColorSigned16(pixel, this.bScale);
    }

    private int getAlphaShort(short[] pixel) {
        if (this.backgroundChannel >= 0) {
            return (int)(255.0f * (1.0f - DefaultColorModel.ushortToFloat(pixel[this.backgroundChannel])));
        }
        if (this.residualBackground) {
            float sum = 0.0f;
            if (this.pixelType == PixelType.UINT16) {
                for (short p : pixel) {
                    sum += DefaultColorModel.ushortToFloat(p);
                }
            } else {
                for (short p : pixel) {
                    sum += DefaultColorModel.clipFloat(DefaultColorModel.shortToFloat(p));
                }
            }
            return (int)(255.0f * DefaultColorModel.clipFloat(sum));
        }
        return 255;
    }

    private int getRedInt(int[] pixel) {
        return this.scaledPixelColorSigned32(pixel, this.rScale);
    }

    private int getGreenInt(int[] pixel) {
        return this.scaledPixelColorSigned32(pixel, this.gScale);
    }

    private int getBlueInt(int[] pixel) {
        return this.scaledPixelColorSigned32(pixel, this.bScale);
    }

    private int getAlphaInt(int[] pixel) {
        if (this.backgroundChannel >= 0) {
            return (int)(255.0f * (1.0f - DefaultColorModel.intToFloat(pixel[this.backgroundChannel])));
        }
        if (this.residualBackground) {
            float sum = 0.0f;
            for (int p : pixel) {
                sum += DefaultColorModel.clipFloat(DefaultColorModel.intToFloat(p));
            }
            return (int)(255.0f * DefaultColorModel.clipFloat(sum));
        }
        return 255;
    }

    private int scaledPixelColor(double[] pixel, float[] scale) {
        double sum = 0.0;
        for (int i = 0; i < pixel.length; ++i) {
            if (this.backgroundChannel == i) continue;
            sum += pixel[i] * (double)scale[i];
        }
        return (int)(255.0f * DefaultColorModel.clipFloat((float)sum));
    }

    private int scaledPixelColor(float[] pixel, float[] scale) {
        float sum = 0.0f;
        for (int i = 0; i < pixel.length; ++i) {
            if (this.backgroundChannel == i) continue;
            sum += pixel[i] * scale[i];
        }
        return (int)(255.0f * DefaultColorModel.clipFloat(sum));
    }

    private int scaledPixelColor(byte[] pixel, float[] scale) {
        float sum = 0.0f;
        for (int i = 0; i < pixel.length; ++i) {
            if (this.backgroundChannel == i) continue;
            sum += DefaultColorModel.byteToFloat(pixel[i]) * scale[i];
        }
        return (int)(255.0f * DefaultColorModel.clipFloat(sum));
    }

    private int scaledPixelColorSigned16(short[] pixel, float[] scale) {
        float sum = 0.0f;
        for (int i = 0; i < pixel.length; ++i) {
            if (this.backgroundChannel == i) continue;
            sum += DefaultColorModel.shortToFloat(pixel[i]) * scale[i];
        }
        return (int)(255.0f * DefaultColorModel.clipFloat(sum));
    }

    private int scaledPixelColorSigned32(int[] pixel, float[] scale) {
        float sum = 0.0f;
        for (int i = 0; i < pixel.length; ++i) {
            if (this.backgroundChannel == i) continue;
            sum += DefaultColorModel.intToFloat(pixel[i]) * scale[i];
        }
        return (int)(255.0f * DefaultColorModel.clipFloat(sum));
    }

    private int scaledPixelColorU16(short[] pixel, float[] scale) {
        float sum = 0.0f;
        for (int i = 0; i < pixel.length; ++i) {
            if (this.backgroundChannel == i) continue;
            sum += DefaultColorModel.ushortToFloat(pixel[i]) * scale[i];
        }
        return (int)(255.0f * DefaultColorModel.clipFloat(sum));
    }

    private static float clipFloat(double f) {
        if (f < 0.0) {
            return 0.0f;
        }
        if (f > 1.0) {
            return 1.0f;
        }
        return (float)f;
    }

    private static float clipFloat(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    private static float intToFloat(int s) {
        return (float)((double)s / 2.147483647E9);
    }

    private static float shortToFloat(short s) {
        return (float)s / 32767.0f;
    }

    private static float ushortToFloat(short s) {
        int val = s & 0xFFFF;
        return (float)val / 65535.0f;
    }

    private static float byteToFloat(byte b) {
        int val = b & 0xFF;
        if (val > 255) {
            return 1.0f;
        }
        return (float)val / 255.0f;
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        int transferType = raster.getTransferType();
        return transferType == 0 || transferType == 1 || transferType == 3 || transferType == 2 || transferType == 4 || transferType == 5;
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        switch (this.pixelType) {
            case FLOAT32: {
                return WritableRaster.createWritableRaster(new BandedSampleModel(4, w, h, this.nBands), new DataBufferFloat(w * h, this.nBands), null);
            }
            case FLOAT64: {
                return WritableRaster.createWritableRaster(new BandedSampleModel(5, w, h, this.nBands), new DataBufferDouble(w * h, this.nBands), null);
            }
            case INT16: {
                return WritableRaster.createWritableRaster(new BandedSampleModel(2, w, h, this.nBands), new DataBufferShort(w * h, this.nBands), null);
            }
            case INT32: {
                return WritableRaster.createBandedRaster(3, w, h, this.nBands, null);
            }
            case UINT16: {
                return WritableRaster.createBandedRaster(1, w, h, this.nBands, null);
            }
            case UINT8: {
                return WritableRaster.createBandedRaster(0, w, h, this.nBands, null);
            }
        }
        try {
            return super.createCompatibleWritableRaster(w, h);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unsupported pixel type " + String.valueOf((Object)this.pixelType));
        }
    }

    @Override
    public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        logger.warn("Unsupported call to coerce data for {} (isAlphaPremultiplied = {})", (Object)raster, (Object)isAlphaPremultiplied);
        return null;
    }
}

