/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.common;

public final class ColorTools {
    public static final Integer WHITE = ColorTools.packRGB(255, 255, 255);
    public static final Integer BLACK = ColorTools.packRGB(0, 0, 0);
    public static final Integer RED = ColorTools.packRGB(255, 0, 0);
    public static final Integer GREEN = ColorTools.packRGB(0, 255, 0);
    public static final Integer BLUE = ColorTools.packRGB(0, 0, 255);
    public static final Integer MAGENTA = ColorTools.packRGB(255, 0, 255);
    public static final Integer CYAN = ColorTools.packRGB(0, 255, 255);
    public static final Integer YELLOW = ColorTools.packRGB(255, 255, 0);
    public static final Integer MASK_ALPHA = -16777216;
    public static final Integer MASK_RED = 0xFF0000;
    public static final Integer MASK_GREEN = 65280;
    public static final Integer MASK_BLUE = 255;

    private ColorTools() {
        throw new AssertionError();
    }

    @Deprecated
    public static int makeRGB(int r, int g, int b) {
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public static int packRGB(int r, int g, int b) {
        return -16777216 + ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }

    public static int[] unpackRGB(int rgb) {
        return ColorTools.unpackRGB(rgb, null);
    }

    public static int[] unpackRGB(int rgb, int[] array) {
        if (array == null || array.length < 3) {
            array = new int[]{ColorTools.red(rgb), ColorTools.green(rgb), ColorTools.blue(rgb)};
        }
        return array;
    }

    public static int[] unpackARGB(int rgb) {
        return ColorTools.unpackARGB(rgb, null);
    }

    public static int[] unpackARGB(int rgb, int[] array) {
        if (array == null || array.length < 4) {
            array = new int[]{ColorTools.alpha(rgb), ColorTools.red(rgb), ColorTools.green(rgb), ColorTools.blue(rgb)};
        }
        return array;
    }

    public static int packClippedRGB(int r, int g, int b) {
        return ColorTools.packRGB(ColorTools.do8BitRangeCheck(r), ColorTools.do8BitRangeCheck(g), ColorTools.do8BitRangeCheck(b));
    }

    @Deprecated
    public static int makeRGBA(int r, int g, int b, int a) {
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static int packARGB(int a, int r, int g, int b) {
        return ((a & 0xFF) << 24) + ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }

    public static int packClippedARGB(int a, int r, int g, int b) {
        return ColorTools.packARGB(ColorTools.do8BitRangeCheck(a), ColorTools.do8BitRangeCheck(r), ColorTools.do8BitRangeCheck(g), ColorTools.do8BitRangeCheck(b));
    }

    public static int do8BitRangeCheck(int v) {
        return v < 0 ? 0 : (v > 255 ? 255 : v);
    }

    public static int do8BitRangeCheck(float v) {
        return v < 0.0f ? 0 : (v > 255.0f ? 255 : (int)v);
    }

    public static int do8BitRangeCheck(double v) {
        return v < 0.0 ? 0 : (v > 255.0 ? 255 : (int)v);
    }

    public static int alpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int red(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int green(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int blue(int rgb) {
        return rgb & 0xFF;
    }

    public static int makeScaledRGB(int rgb, double scale) {
        return ColorTools.packRGB((int)Math.min(255.0, (double)ColorTools.red(rgb) * scale), (int)Math.min(255.0, (double)ColorTools.green(rgb) * scale), (int)Math.min(255.0, (double)ColorTools.blue(rgb) * scale));
    }

    public static int clip255(double val) {
        return (int)Math.min(255.0, Math.max(val, 0.0));
    }
}

