/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.common;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class LogTools {
    private static Map<Logger, Map<Level, Set<String>>> alreadyLogged = new ConcurrentHashMap<Logger, Map<Level, Set<String>>>();

    public static boolean logOnce(Logger logger, Level level, String message) {
        Map map = alreadyLogged.computeIfAbsent(logger, l -> new ConcurrentHashMap());
        Set set = map.computeIfAbsent(level, l -> ConcurrentHashMap.newKeySet());
        if (set.add(message)) {
            logger.atLevel(level).log(message);
            return true;
        }
        return false;
    }

    public static boolean logOnce(Logger logger, String message) {
        return LogTools.logOnce(logger, Level.INFO, message);
    }

    public static boolean warnOnce(Logger logger, String message) {
        return LogTools.logOnce(logger, Level.WARN, message);
    }
}

