/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.common;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadTools {
    private static final Logger logger = LoggerFactory.getLogger(ThreadTools.class);
    private static int requestedThreads = ForkJoinPool.getCommonPoolParallelism();

    public static ThreadFactory createThreadFactory(String prefix, boolean daemon, int priority) {
        return new SimpleThreadFactory(prefix, daemon, priority);
    }

    public static ThreadFactory createThreadFactory(String prefix, boolean daemon) {
        return ThreadTools.createThreadFactory(prefix, daemon, 5);
    }

    public static void setParallelism(int nThreads) {
        if (nThreads <= 0) {
            throw new IllegalArgumentException("Number of threads must be >= 1, but requested number is " + nThreads);
        }
        logger.info("Setting parallelism to {}", (Object)nThreads);
        requestedThreads = nThreads;
    }

    public static int getParallelism() {
        return requestedThreads;
    }

    static {
        logger.debug("Common ForkJoinPool parallelism: {}", (Object)ThreadTools.getParallelism());
    }

    static class SimpleThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private String prefix;
        private boolean daemon;
        private int priority;

        SimpleThreadFactory(String prefix, boolean daemon, int priority) {
            this.group = Thread.currentThread().getThreadGroup();
            this.prefix = prefix;
            this.daemon = daemon;
            this.priority = Math.max(1, Math.min(10, priority));
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.getAndIncrement();
            Thread t = new Thread(this.group, r, name, 0L);
            t.setDaemon(this.daemon);
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            return t;
        }
    }
}

