/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.geom;

import qupath.lib.geom.Point;

abstract class AbstractPoint
implements Point {
    AbstractPoint() {
    }

    @Override
    public double distanceSq(Point p) {
        if (p.dim() != this.dim()) {
            throw new RuntimeException("Cannot measure distance between points with different dimensionality (" + this.dim() + " and " + p.dim());
        }
        double sum = 0.0;
        for (int i = 0; i < this.dim(); ++i) {
            double delta = this.get(i) - p.get(i);
            sum += delta * delta;
        }
        return sum;
    }

    @Override
    public double distance(Point p) {
        return Math.sqrt(this.distanceSq(p));
    }
}

