/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.geom;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.AbstractPoint;

public class Point2
extends AbstractPoint
implements Externalizable {
    static Logger logger = LoggerFactory.getLogger(Point2.class);
    private double x;
    private double y;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point2 other = (Point2)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public Point2() {
    }

    public Point2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double distanceSq(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public double distance(double x, double y) {
        return Math.sqrt(this.distanceSq(x, y));
    }

    public double distance(Point2 p) {
        return this.distance(p.getX(), p.getY());
    }

    @Override
    public double get(int dim) {
        if (dim == 0) {
            return this.x;
        }
        if (dim == 1) {
            return this.y;
        }
        throw new IllegalArgumentException("Requested dimension " + dim + " for Point2 - allowable values are 0 and 1");
    }

    @Override
    public int dim() {
        return 2;
    }

    public String toString() {
        return "Point: " + this.x + ", " + this.y;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.skipBytes(4);
        this.x = in.readDouble();
        this.y = in.readDouble();
    }
}

