/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.images.servers.TileRequestManager;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public abstract class AbstractImageServer<T>
implements ImageServer<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractImageServer.class);
    private ImageServerMetadata userMetadata;
    private transient Map<RegionRequest, T> cache;
    private transient ImageServerBuilder.ServerBuilder<T> builder;
    private String id;
    private Class<T> imageClass;
    private DefaultTileRequestManager tileRequestManager;

    protected AbstractImageServer(Class<T> imageClass) {
        this.imageClass = imageClass;
        this.cache = ImageServerProvider.getCache(imageClass);
    }

    @Override
    public Class<T> getImageClass() {
        return this.imageClass;
    }

    protected Map<RegionRequest, T> getCache() {
        return this.cache;
    }

    protected double getThumbnailDownsampleFactor(int maxWidth, int maxHeight) {
        if (maxWidth <= 0) {
            if (maxHeight <= 0) {
                maxWidth = 1024;
                maxHeight = 1024;
            } else {
                maxWidth = Integer.MAX_VALUE;
            }
        } else if (maxHeight <= 0) {
            maxHeight = Integer.MAX_VALUE;
        }
        double xDownsample = (double)this.getWidth() / (double)maxWidth;
        double yDownsample = (double)this.getHeight() / (double)maxHeight;
        double downsample = Math.max(xDownsample, yDownsample);
        if (downsample < 1.0) {
            downsample = 1.0;
        }
        return downsample;
    }

    protected abstract ImageServerBuilder.ServerBuilder<T> createServerBuilder();

    @Override
    public ImageServerBuilder.ServerBuilder<T> getBuilder() {
        if (this.builder == null) {
            this.builder = this.createServerBuilder();
        }
        return this.builder;
    }

    @Override
    public double getDownsampleForResolution(int level) {
        return this.getMetadata().getDownsampleForLevel(level);
    }

    @Override
    public void close() throws Exception {
        logger.trace("Server {} is being closed now", (Object)this);
    }

    @Override
    public int nResolutions() {
        return this.getMetadata().nLevels();
    }

    @Override
    public double[] getPreferredDownsamples() {
        return this.getMetadata().getPreferredDownsamplesArray();
    }

    @Override
    public boolean isRGB() {
        return this.getMetadata().isRGB();
    }

    @Override
    public PixelType getPixelType() {
        return this.getMetadata().getPixelType();
    }

    @Override
    public boolean isEmptyRegion(RegionRequest request) {
        return false;
    }

    public String toString() {
        return this.getServerType() + ": " + this.getPath() + " (" + ServerTools.getDisplayableImageName(this) + ")";
    }

    @Override
    public T getCachedTile(TileRequest tile) {
        Map<RegionRequest, T> cache = this.getCache();
        return cache == null ? null : cache.getOrDefault(tile.getRegionRequest(), null);
    }

    protected abstract String createID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPath() {
        if (this.id == null) {
            AbstractImageServer abstractImageServer = this;
            synchronized (abstractImageServer) {
                String myID = this.createID();
                if (this.id == null) {
                    this.id = myID;
                }
            }
        }
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.getMetadata().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getMetadata().getHeight();
    }

    @Override
    public int nChannels() {
        return this.getMetadata().getSizeC();
    }

    @Override
    public int nZSlices() {
        return this.getMetadata().getSizeZ();
    }

    @Override
    public int nTimepoints() {
        return this.getMetadata().getSizeT();
    }

    @Override
    public synchronized ImageServerMetadata getMetadata() {
        return this.userMetadata == null ? this.getOriginalMetadata() : this.userMetadata;
    }

    @Override
    public synchronized void setMetadata(ImageServerMetadata metadata) {
        if (Objects.equals(metadata, this.getMetadata())) {
            return;
        }
        ImageServerMetadata originalMetadata = this.getOriginalMetadata();
        if (!originalMetadata.isCompatibleMetadata(metadata)) {
            throw new IllegalArgumentException("Specified metadata is incompatible with original metadata for " + String.valueOf(this));
        }
        if (!this.getMetadata().getLevels().equals(metadata.getLevels())) {
            this.tileRequestManager = null;
        }
        this.userMetadata = metadata;
        this.builder = null;
    }

    @Override
    public List<String> getAssociatedImageList() {
        return Collections.emptyList();
    }

    @Override
    public T getAssociatedImage(String name) {
        throw new IllegalArgumentException("No associated image with name '" + name + "' for " + this.getPath());
    }

    @Override
    public ImageChannel getChannel(int channel) {
        return this.getMetadata().getChannel(channel);
    }

    @Override
    public T getDefaultThumbnail(int z, int t) throws IOException {
        int ind;
        double targetDownsample = Math.sqrt((double)this.getWidth() / 1024.0 * (double)this.getHeight() / 1024.0);
        double[] downsamples = this.getPreferredDownsamples();
        for (ind = this.nResolutions() - 1; ind > 0 && downsamples[ind - 1] >= targetDownsample; --ind) {
        }
        double downsample = downsamples[ind];
        RegionRequest request = RegionRequest.createInstance(this.getPath(), downsample, 0, 0, this.getWidth(), this.getHeight(), z, t);
        return this.readRegion(request);
    }

    @Override
    public synchronized TileRequestManager getTileRequestManager() {
        if (this.tileRequestManager == null || this.tileRequestManager.currentMetadata != this.getMetadata()) {
            this.tileRequestManager = new DefaultTileRequestManager(TileRequest.getAllTileRequests(this));
        }
        return this.tileRequestManager;
    }

    private class DefaultTileRequestManager
    implements TileRequestManager {
        private Collection<TileRequest> allTiles;
        private Map<String, SpatialIndex> tiles = new LinkedHashMap<String, SpatialIndex>();
        private ImageServerMetadata currentMetadata;

        private String getKey(TileRequest tile) {
            return this.getKey(tile.getLevel(), tile.getZ(), tile.getT());
        }

        private String getKey(int level, int z, int t) {
            return level + ":" + z + ":" + t;
        }

        DefaultTileRequestManager(Collection<TileRequest> tiles) {
            this.currentMetadata = AbstractImageServer.this.getMetadata();
            this.allTiles = Collections.unmodifiableList(new ArrayList<TileRequest>(tiles));
            for (TileRequest tile : this.allTiles) {
                String key = this.getKey(tile);
                SpatialIndex set = this.tiles.get(key);
                if (set == null) {
                    set = new Quadtree();
                    this.tiles.put(key, set);
                }
                set.insert(this.getEnvelope(tile.getRegionRequest()), (Object)tile);
            }
        }

        @Override
        public Collection<TileRequest> getAllTileRequests() {
            return this.allTiles;
        }

        @Override
        public TileRequest getTileRequest(int level, int x, int y, int z, int t) {
            String key = this.getKey(level, z, t);
            SpatialIndex set = this.tiles.get(key);
            if (set != null) {
                for (Object obj : set.query(new Envelope((double)x, (double)x, (double)y, (double)y))) {
                    TileRequest tile = (TileRequest)obj;
                    if (tile.getLevel() != level || !tile.getRegionRequest().contains(x, y, z, t)) continue;
                    return tile;
                }
            }
            return null;
        }

        private Envelope getEnvelope(ImageRegion region) {
            return new Envelope((double)region.getX(), (double)(region.getX() + region.getWidth()), (double)region.getY(), (double)(region.getY() + region.getHeight()));
        }

        public List<TileRequest> getTileRequests(RegionRequest request) {
            int level = ServerTools.getPreferredResolutionLevel(AbstractImageServer.this, request.getDownsample());
            String key = this.getKey(level, request.getZ(), request.getT());
            SpatialIndex set = this.tiles.get(key);
            ArrayList<TileRequest> list = new ArrayList<TileRequest>();
            if (set != null) {
                for (Object obj : set.query(this.getEnvelope(request))) {
                    TileRequest tile = (TileRequest)obj;
                    if (!request.intersects(tile.getRegionRequest())) continue;
                    list.add(tile);
                }
            }
            return list;
        }

        @Override
        public Collection<TileRequest> getTileRequestsForLevel(int level) {
            return this.getAllTileRequests().stream().filter(t -> t.getLevel() == level).toList();
        }
    }
}

