/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.io.GsonTools;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class AffineTransformImageServer
extends TransformingImageServer<BufferedImage> {
    private static Logger logger = LoggerFactory.getLogger(AffineTransformImageServer.class);
    private ImageServerMetadata metadata;
    private transient ImageRegion region;
    private AffineTransform transform;
    private transient AffineTransform transformInverse;

    protected AffineTransformImageServer(ImageServer<BufferedImage> server, AffineTransform transform) throws NoninvertibleTransformException {
        super(server);
        logger.trace("Creating server for {} and Affine transform {}", server, (Object)transform);
        this.transform = new AffineTransform(transform);
        this.transformInverse = transform.createInverse();
        Rectangle2D boundsTransformed = transform.createTransformedShape(new Rectangle2D.Double(0.0, 0.0, server.getWidth(), server.getHeight())).getBounds2D();
        this.region = ImageRegion.createInstance((int)boundsTransformed.getMinX(), (int)boundsTransformed.getMinY(), (int)Math.ceil(boundsTransformed.getWidth()), (int)Math.ceil(boundsTransformed.getHeight()), 0, 0);
        ImageServerMetadata.ImageResolutionLevel.Builder levelBuilder = new ImageServerMetadata.ImageResolutionLevel.Builder(this.region.getWidth(), this.region.getHeight());
        boolean fullServer = server.getWidth() == this.region.getWidth() && server.getHeight() == this.region.getHeight();
        int i = 0;
        do {
            ImageServerMetadata.ImageResolutionLevel originalLevel = server.getMetadata().getLevel(i);
            if (fullServer) {
                levelBuilder.addLevel(originalLevel);
                continue;
            }
            levelBuilder.addLevelByDownsample(originalLevel.getDownsample());
        } while (++i < server.nResolutions() && this.region.getWidth() >= server.getMetadata().getPreferredTileWidth() && this.region.getHeight() >= server.getMetadata().getPreferredTileHeight());
        ImageServerMetadata.Builder builder = new ImageServerMetadata.Builder(server.getMetadata()).width(this.region.getWidth()).height(this.region.getHeight()).name(String.format("%s (%s)", server.getMetadata().getName(), transform.toString())).levels(levelBuilder.build());
        PixelCalibration calUpdated = AffineTransformImageServer.updatePixelCalibration(server.getPixelCalibration(), transform);
        if (!calUpdated.equals(server.getPixelCalibration())) {
            if (!calUpdated.equals(PixelCalibration.getDefaultInstance())) {
                logger.debug("Pixel calibration updated to {}", (Object)calUpdated);
            }
            builder.pixelSizeMicrons(calUpdated.getPixelWidthMicrons(), calUpdated.getPixelHeightMicrons());
        }
        this.metadata = builder.build();
    }

    static PixelCalibration updatePixelCalibration(PixelCalibration cal, AffineTransform transform) {
        if (transform.isIdentity() || cal.unitsMatch2D() && "px".equals(cal.getPixelWidthUnit()) && cal.getPixelWidth().doubleValue() == 1.0 && cal.getPixelHeight().doubleValue() == 1.0) {
            return cal;
        }
        try {
            transform = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.warn("Transform is not invertible! I will use the default pixel calibration.");
            return PixelCalibration.getDefaultInstance();
        }
        int type = transform.getType();
        if ((type & 0x20) != 0) {
            logger.warn("Arbitrary transform cannot be decomposed! I will use the default pixel calibration.");
            return PixelCalibration.getDefaultInstance();
        }
        double[] temp = new double[]{1.0, 0.0, 0.0, 1.0};
        transform.deltaTransform(temp, 0, temp, 0, 2);
        double xScale = Math.sqrt(temp[0] * temp[0] + temp[1] * temp[1]);
        double yScale = Math.sqrt(temp[2] * temp[2] + temp[3] * temp[3]);
        double pixelWidth = cal.getPixelWidth().doubleValue();
        double pixelHeight = cal.getPixelHeight().doubleValue();
        if ((type & 8) != 0 && temp[0] == 0.0 && temp[3] == 0.0) {
            double pixelWidthOutput = pixelHeight * yScale;
            double pixelHeightOutput = pixelWidth * xScale;
            xScale = pixelWidthOutput / pixelWidth;
            yScale = pixelHeightOutput / pixelHeight;
        } else if ((type & 0x10) != 0 && pixelWidth != pixelHeight) {
            logger.warn("General rotation with non-square pixels is not supported ({} vs {})! I will use the default pixel calibration.", (Object)pixelWidth, (Object)pixelHeight);
            return PixelCalibration.getDefaultInstance();
        }
        return cal.createScaledInstance(xScale, yScale);
    }

    @Override
    protected String createID() {
        return this.getClass().getName() + ": + " + this.getWrappedServer().getPath() + " " + GsonTools.getInstance().toJson((Object)this.transform);
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        double downsample = request.getDownsample();
        Rectangle bounds = AwtTools.getBounds(request);
        Rectangle boundsTransformed = this.transformInverse.createTransformedShape(bounds).getBounds();
        ImageServer wrappedServer = this.getWrappedServer();
        int minX = Math.max(0, (int)boundsTransformed.getMinX() - 1);
        int maxX = Math.min(wrappedServer.getWidth(), (int)Math.ceil(boundsTransformed.getMaxX() + 1.0));
        int minY = Math.max(0, (int)boundsTransformed.getMinY() - 1);
        int maxY = Math.min(wrappedServer.getHeight(), (int)Math.ceil(boundsTransformed.getMaxY() + 1.0));
        RegionRequest requestTransformed = RegionRequest.createInstance(wrappedServer.getPath(), downsample, minX, minY, maxX - minX, maxY - minY, request.getZ(), request.getT());
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(requestTransformed);
        if (img == null) {
            return img;
        }
        int w = (int)((double)request.getWidth() / downsample);
        int h = (int)((double)request.getHeight() / downsample);
        AffineTransform transform2 = new AffineTransform();
        transform2.scale(1.0 / downsample, 1.0 / downsample);
        transform2.translate(-request.getX(), -request.getY());
        transform2.concatenate(this.transform);
        if (BufferedImageTools.is8bitColorType(img.getType()) || img.getType() == 10) {
            BufferedImage img2 = new BufferedImage(w, h, img.getType());
            Graphics2D g2d = img2.createGraphics();
            g2d.transform(transform2);
            g2d.drawImage(img, requestTransformed.getX(), requestTransformed.getY(), requestTransformed.getWidth(), requestTransformed.getHeight(), null);
            g2d.dispose();
            return img2;
        }
        WritableRaster rasterOrig = img.getRaster();
        WritableRaster raster = rasterOrig.createCompatibleWritableRaster(w, h);
        double[] row = new double[w * 2];
        double[] row2 = new double[w * 2];
        try {
            transform2 = transform2.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IOException(e);
        }
        Object elements = null;
        for (int y = 0; y < h; ++y) {
            int x;
            for (x = 0; x < w; ++x) {
                row[x * 2] = x;
                row[x * 2 + 1] = y;
            }
            transform2.transform(row, 0, row2, 0, w);
            for (x = 0; x < w; ++x) {
                int xx = (int)((row2[x * 2] - (double)requestTransformed.getX()) / downsample);
                int yy = (int)((row2[x * 2 + 1] - (double)requestTransformed.getY()) / downsample);
                if (xx < 0 || yy < 0 || xx >= img.getWidth() || yy >= img.getHeight()) continue;
                elements = rasterOrig.getDataElements(xx, yy, elements);
                raster.setDataElements(x, y, elements);
            }
        }
        return new BufferedImage(img.getColorModel(), raster, img.isAlphaPremultiplied(), null);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    public String getServerType() {
        return "Affine transform server";
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.AffineTransformImageServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.getTransform());
    }
}

