/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.regions.RegionRequest;

public class ChannelTransformFeatureServer
extends TransformingImageServer<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelTransformFeatureServer.class);
    private List<ColorTransforms.ColorTransform> transforms;
    private ImageServerMetadata metadata;
    private ColorModel colorModel;

    ChannelTransformFeatureServer(ImageServer<BufferedImage> server, List<ColorTransforms.ColorTransform> transforms) {
        super(server);
        String name;
        logger.trace("Creating server for {} and color transforms {}", server, transforms);
        this.transforms = new ArrayList<ColorTransforms.ColorTransform>(transforms);
        ArrayList<ImageChannel> channels = new ArrayList<ImageChannel>();
        List<ImageChannel> wrappedChannels = server.getMetadata().getChannels();
        int k = 0;
        for (ColorTransforms.ColorTransform t2 : transforms) {
            int ind = -1;
            if (t2 instanceof ColorTransforms.ExtractChannel) {
                ind = ((ColorTransforms.ExtractChannel)t2).getChannelNumber();
            } else if (t2 instanceof ColorTransforms.ExtractChannelByName) {
                String name2 = ((ColorTransforms.ExtractChannelByName)t2).getChannelName();
                int i = 0;
                for (ImageChannel c : wrappedChannels) {
                    if (name2.equals(c.getName())) {
                        ind = i;
                        break;
                    }
                    ++i;
                }
            }
            if (ind >= 0 && ind < wrappedChannels.size()) {
                channels.add(wrappedChannels.get(ind));
            } else {
                channels.add(ImageChannel.getInstance(t2.getName(), ImageChannel.getDefaultChannelColor(k)));
            }
            ++k;
        }
        if (transforms.size() > 0 && transforms.size() <= 4) {
            String names = transforms.stream().map(t -> t.getName()).collect(Collectors.joining(","));
            name = String.format("%s (%s)", server.getMetadata().getName(), names);
        } else {
            name = String.format("%s (%d channels)", server.getMetadata().getName(), transforms.size());
        }
        this.metadata = new ImageServerMetadata.Builder(server.getMetadata()).pixelType(PixelType.FLOAT32).rgb(false).channels(channels).name(name).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ColorModel getColorModel() {
        if (this.colorModel == null) {
            ChannelTransformFeatureServer channelTransformFeatureServer = this;
            synchronized (channelTransformFeatureServer) {
                this.colorModel = ColorModelFactory.createColorModel(this.getMetadata().getPixelType(), this.getMetadata().getChannels());
            }
        }
        return this.colorModel;
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.ChannelTransformFeatureServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.transforms);
    }

    @Override
    protected String createID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(request);
        if (img == null) {
            return null;
        }
        ImageServer<BufferedImage> server = this.getWrappedServer();
        WritableRaster raster = ChannelTransformFeatureServer.transformRaster(server, img, this.transforms);
        return new BufferedImage(this.getColorModel(), raster, false, null);
    }

    static WritableRaster transformRaster(ImageServer<BufferedImage> server, BufferedImage img, List<ColorTransforms.ColorTransform> transforms) {
        int w = img.getWidth();
        int h = img.getHeight();
        int nChannels = transforms.size();
        BandedSampleModel model = new BandedSampleModel(4, w, h, nChannels);
        float[][] bytes = new float[nChannels][w * h];
        DataBufferFloat buffer = new DataBufferFloat(bytes, w * h);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        for (int b = 0; b < transforms.size(); ++b) {
            transforms.get(b).extractChannel(server, img, bytes[b]);
        }
        return raster;
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    public String getServerType() {
        return "Channel transform server";
    }
}

